/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.classloading;

import java.util.Map;
import org.jboss.classloading.plugins.metadata.ModuleCapability;
import org.jboss.classloading.spi.dependency.Module;
import org.jboss.classloading.spi.metadata.Requirement;
import org.jboss.classloading.spi.version.VersionRange;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.osgi.framework.bundle.AbstractBundleState;
import org.jboss.osgi.framework.bundle.DeployedBundleState;
import org.jboss.osgi.framework.bundle.OSGiBundleManager;
import org.jboss.osgi.framework.classloading.OSGiBundleRequirement;
import org.jboss.osgi.framework.classloading.OSGiCapability;
import org.jboss.osgi.framework.classloading.OSGiFragmentHostRequirement;
import org.jboss.osgi.framework.classloading.OSGiModule;
import org.jboss.osgi.framework.metadata.OSGiMetaData;
import org.jboss.osgi.framework.metadata.ParameterizedAttribute;
import org.jboss.osgi.framework.plugins.ResolverPlugin;
import org.osgi.framework.Version;

public class OSGiBundleCapability
extends ModuleCapability
implements OSGiCapability {
    private static final long serialVersionUID = 2366716668262831380L;
    private AbstractBundleState bundleState;

    public static OSGiBundleCapability create(AbstractBundleState bundleState) {
        if (bundleState == null) {
            throw new IllegalArgumentException("Null bundleState");
        }
        String symbolicName = bundleState.getSymbolicName();
        Version version = bundleState.getVersion();
        return new OSGiBundleCapability(symbolicName, version, bundleState);
    }

    private OSGiBundleCapability(String name, Version version, AbstractBundleState bundleState) {
        super(name, (Object)version);
        if (bundleState == null) {
            throw new IllegalArgumentException("Null bundleState");
        }
        this.bundleState = bundleState;
    }

    @Override
    public AbstractBundleState getBundleState() {
        return this.bundleState;
    }

    public OSGiMetaData getMetaData() {
        return this.bundleState.getOSGiMetaData();
    }

    public boolean resolves(Module reqModule, Requirement mcreq) {
        if (!(mcreq instanceof OSGiBundleRequirement)) {
            return false;
        }
        OSGiBundleRequirement osgireq = (OSGiBundleRequirement)mcreq;
        OSGiBundleManager bundleManager = this.bundleState.getBundleManager();
        ResolverPlugin resolver = bundleManager.getOptionalPlugin(ResolverPlugin.class);
        if (resolver == null) {
            boolean match = super.resolves(reqModule, mcreq);
            return match &= this.matchAttributes(mcreq);
        }
        OSGiCapability osgicap = resolver.getWiredCapability(osgireq);
        if (osgicap != null) {
            boolean match = osgicap == this;
            return match;
        }
        if (osgireq instanceof OSGiFragmentHostRequirement) {
            boolean match = super.resolves(reqModule, mcreq);
            return match &= this.matchAttributes(mcreq);
        }
        return false;
    }

    @Override
    public OSGiModule getModule() {
        DeployedBundleState depBundle;
        DeploymentUnit unit;
        OSGiModule module = null;
        if (this.bundleState instanceof DeployedBundleState && (module = (OSGiModule)((Object)(unit = (depBundle = (DeployedBundleState)this.bundleState).getDeploymentUnit()).getAttachment(Module.class))) == null) {
            throw new IllegalStateException("Cannot obtain module from: " + (Object)((Object)this.bundleState));
        }
        return module;
    }

    private boolean matchAttributes(Requirement requirement) {
        Version ourVersion = Version.parseVersion((String)this.getMetaData().getBundleVersion());
        OSGiBundleRequirement bundleRequirement = (OSGiBundleRequirement)requirement;
        VersionRange requiredRange = bundleRequirement.getVersionRange();
        boolean match = requiredRange.isInRange((Object)ourVersion);
        return match;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof OSGiBundleCapability)) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        OSGiBundleCapability other = (OSGiBundleCapability)obj;
        return this.getMetaData().equals(other.getMetaData());
    }

    protected void toString(StringBuffer buffer) {
        Map params;
        super.toString(buffer);
        ParameterizedAttribute parameters = this.getMetaData().getBundleParameters();
        if (parameters != null && (params = parameters.getAttributes()) != null && !params.isEmpty()) {
            buffer.append(" attributes=").append(params);
        }
    }
}

