/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.classloading;

import org.jboss.classloader.spi.ClassLoaderPolicy;
import org.jboss.classloader.spi.ClassLoaderPolicyFactory;
import org.jboss.classloader.spi.ClassLoaderSystem;
import org.jboss.classloading.spi.dependency.Module;
import org.jboss.deployers.structure.spi.ClassLoaderFactory;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.osgi.framework.classloading.OSGiModule;

public class OSGiClassLoaderFactory
implements ClassLoaderFactory {
    private ClassLoaderSystem system;

    public void setSystem(ClassLoaderSystem system) {
        this.system = system;
    }

    public ClassLoader createClassLoader(final DeploymentUnit unit) throws Exception {
        if (!(unit instanceof VFSDeploymentUnit)) {
            throw new IllegalStateException("Not an instance of VFSDeploymentUnit: " + unit);
        }
        final OSGiModule module = (OSGiModule)((Object)unit.getAttachment(Module.class));
        module.setPolicyFactory(new ClassLoaderPolicyFactory(){

            public ClassLoaderPolicy createClassLoaderPolicy() {
                VFSDeploymentUnit vfsUnit = (VFSDeploymentUnit)unit;
                return module.createClassLoaderPolicyInternal(vfsUnit);
            }
        });
        return module.registerClassLoaderPolicy(this.system);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeClassLoader(DeploymentUnit unit) throws Exception {
        Module module = (Module)unit.getAttachment(Module.class);
        if (module == null) {
            return;
        }
        ClassLoader classLoader = unit.getClassLoader();
        try {
            this.system.unregisterClassLoader(classLoader);
        }
        finally {
            module.reset();
        }
    }
}

