/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.classloading;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.List;
import org.jboss.classloader.plugins.filter.CombiningClassFilter;
import org.jboss.classloader.plugins.jdk.AbstractJDKChecker;
import org.jboss.classloader.plugins.loader.ClassLoaderToLoaderAdapter;
import org.jboss.classloader.spi.ClassLoaderDomain;
import org.jboss.classloader.spi.ClassLoaderPolicy;
import org.jboss.classloader.spi.ClassLoaderSystem;
import org.jboss.classloader.spi.Loader;
import org.jboss.classloader.spi.ParentPolicy;
import org.jboss.classloader.spi.base.BaseClassLoader;
import org.jboss.classloader.spi.filter.ClassFilter;
import org.jboss.classloader.spi.filter.ClassFilterUtils;
import org.jboss.classloader.spi.filter.PackageClassFilter;
import org.jboss.classloader.spi.filter.RecursivePackageClassFilter;
import org.jboss.osgi.framework.bundle.AbstractBundleState;
import org.jboss.osgi.framework.bundle.OSGiBundleState;
import org.jboss.osgi.framework.classloading.OSGiBundleClassLoader;
import org.jboss.osgi.framework.classloading.OSGiClassLoaderPolicy;
import org.jboss.osgi.framework.classloading.OSGiCoreClassFilter;
import org.jboss.osgi.framework.plugins.SystemPackagesPlugin;

public class OSGiClassLoaderSystem
extends ClassLoaderSystem {
    private SystemPackagesPlugin systemPackages;

    public OSGiClassLoaderSystem(SystemPackagesPlugin systemPackages) {
        if (systemPackages == null) {
            throw new IllegalArgumentException("Null systemPackages");
        }
        this.systemPackages = systemPackages;
        AbstractJDKChecker.getExcluded().add(AbstractBundleState.class);
        AbstractJDKChecker.getExcluded().add(OSGiBundleState.class);
    }

    protected ClassLoaderDomain createDefaultDomain() {
        ClassLoaderDomain defaultDomain = super.createDefaultDomain();
        RecursivePackageClassFilter javaFilter = RecursivePackageClassFilter.createRecursivePackageClassFilter((String[])new String[]{"java"});
        PackageClassFilter systemFilter = PackageClassFilter.createPackageClassFilterFromString((String)this.getSystemPackagesAsString());
        CombiningClassFilter filter = CombiningClassFilter.create((ClassFilter[])new ClassFilter[]{javaFilter, OSGiCoreClassFilter.INSTANCE, systemFilter});
        defaultDomain.setParentPolicy(new ParentPolicy((ClassFilter)filter, ClassFilterUtils.NOTHING));
        Loader parent = AccessController.doPrivileged(new PrivilegedAction<Loader>(){

            @Override
            public Loader run() {
                return new ClassLoaderToLoaderAdapter(this.getClass().getClassLoader());
            }
        });
        defaultDomain.setParent(parent);
        return defaultDomain;
    }

    protected ClassLoaderDomain createDomain(String name) {
        return new ClassLoaderDomain(name);
    }

    protected BaseClassLoader createClassLoader(ClassLoaderPolicy policy) {
        BaseClassLoader classLoader = policy instanceof OSGiClassLoaderPolicy ? new OSGiBundleClassLoader(policy) : super.createClassLoader(policy);
        return classLoader;
    }

    private String getSystemPackagesAsString() {
        List<String> sysPackages = this.systemPackages.getSystemPackages(false);
        StringBuffer sysPackageString = new StringBuffer();
        for (String name : sysPackages) {
            sysPackageString.append(name + ",");
        }
        return sysPackageString.toString();
    }
}

