/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.classloading;

import java.util.Map;
import java.util.StringTokenizer;
import org.jboss.classloader.spi.filter.ClassFilter;
import org.jboss.classloading.plugins.metadata.PackageCapability;
import org.jboss.classloading.spi.dependency.Module;
import org.jboss.classloading.spi.metadata.Requirement;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.osgi.framework.bundle.AbstractBundleState;
import org.jboss.osgi.framework.bundle.DeployedBundleState;
import org.jboss.osgi.framework.bundle.OSGiBundleManager;
import org.jboss.osgi.framework.classloading.OSGiCapability;
import org.jboss.osgi.framework.classloading.OSGiModule;
import org.jboss.osgi.framework.classloading.OSGiPackageRequirement;
import org.jboss.osgi.framework.metadata.OSGiMetaData;
import org.jboss.osgi.framework.metadata.PackageAttribute;
import org.jboss.osgi.framework.metadata.Parameter;
import org.jboss.osgi.framework.metadata.internal.AbstractVersionRange;
import org.jboss.osgi.framework.plugins.ResolverPlugin;
import org.osgi.framework.Version;

public class OSGiPackageCapability
extends PackageCapability
implements OSGiCapability {
    private static final long serialVersionUID = 3940667616588052822L;
    private AbstractBundleState bundleState;
    private PackageAttribute metadata;
    private String[] mandatoryAttributes;
    private String shortString;

    public static OSGiPackageCapability create(AbstractBundleState bundleState, PackageAttribute metadata) {
        if (bundleState == null) {
            throw new IllegalArgumentException("Null bundle");
        }
        String name = metadata.getAttribute();
        String versionString = (String)metadata.getAttributeValue("version", String.class);
        String oldVersionString = (String)metadata.getAttributeValue("specification-version", String.class);
        if (oldVersionString != null) {
            if (versionString != null && !versionString.equals(oldVersionString)) {
                throw new IllegalStateException("version of " + versionString + " does not match " + "specification-version" + " of " + oldVersionString);
            }
            if (versionString == null) {
                versionString = oldVersionString;
            }
        }
        Version version = null;
        if (versionString != null) {
            if (versionString.startsWith("\"") && versionString.endsWith("\"")) {
                versionString = versionString.substring(1, versionString.length() - 1);
            }
            version = Version.parseVersion((String)versionString);
        }
        OSGiPackageCapability capability = new OSGiPackageCapability(bundleState, name, version, metadata);
        capability.setSplitPackagePolicy(PackageCapability.SplitPackagePolicy.First);
        return capability;
    }

    private OSGiPackageCapability(AbstractBundleState bundleState, String name, Version version, PackageAttribute metadata) {
        super(name, (Object)version);
        this.bundleState = bundleState;
        this.metadata = metadata;
        String mandatory = (String)metadata.getDirectiveValue("mandatory", String.class);
        if (mandatory != null) {
            StringTokenizer tokens = new StringTokenizer(mandatory, ",");
            this.mandatoryAttributes = new String[tokens.countTokens()];
            int i = 0;
            while (tokens.hasMoreTokens()) {
                this.mandatoryAttributes[i++] = tokens.nextToken();
            }
        }
        if (metadata.getAttribute("bundle-symbolic-name") != null) {
            throw new IllegalStateException("You cannot specify bundle-symbolic-name on an Export-Package");
        }
        if (metadata.getAttribute("bundle-version") != null) {
            throw new IllegalStateException("You cannot specify bundle-version on an Export-Package");
        }
    }

    @Override
    public AbstractBundleState getBundleState() {
        return this.bundleState;
    }

    public PackageAttribute getMetadata() {
        return this.metadata;
    }

    public boolean resolves(Module reqModule, Requirement mcreq) {
        if (!(mcreq instanceof OSGiPackageRequirement)) {
            boolean match = super.resolves(reqModule, mcreq);
            return match;
        }
        OSGiPackageRequirement osgireq = (OSGiPackageRequirement)mcreq;
        OSGiBundleManager bundleManager = this.bundleState.getBundleManager();
        ResolverPlugin resolver = bundleManager.getOptionalPlugin(ResolverPlugin.class);
        if (resolver == null || osgireq.isDynamic() && !osgireq.isOptional()) {
            boolean match = super.resolves(reqModule, mcreq);
            return match &= this.matchAttributes(osgireq);
        }
        OSGiCapability osgicap = resolver.getWiredCapability(osgireq);
        if (osgicap != null) {
            boolean match = osgicap == this;
            return match;
        }
        return false;
    }

    @Override
    public OSGiModule getModule() {
        DeployedBundleState depBundle;
        DeploymentUnit unit;
        OSGiModule module = null;
        if (this.bundleState instanceof DeployedBundleState && (module = (OSGiModule)((Object)(unit = (depBundle = (DeployedBundleState)this.bundleState).getDeploymentUnit()).getAttachment(Module.class))) == null) {
            throw new IllegalStateException("Cannot obtain module from: " + (Object)((Object)this.bundleState));
        }
        return module;
    }

    public boolean matchNameAndVersion(OSGiPackageRequirement packageRequirement) {
        ClassFilter filter;
        if (packageRequirement.isWildcard() ? !(filter = packageRequirement.toClassFilter()).matchesPackageName(this.getName()) : !this.getName().equals(packageRequirement.getName())) {
            return false;
        }
        boolean inRange = packageRequirement.getVersionRange().isInRange(this.getVersion());
        return inRange;
    }

    public boolean matchAttributes(OSGiPackageRequirement packageRequirement) {
        Map params;
        OSGiMetaData osgiMetaData = this.bundleState.getOSGiMetaData();
        PackageAttribute capParameters = this.metadata;
        PackageAttribute reqParameters = packageRequirement.getMetadata();
        boolean validMatch = true;
        if (validMatch && this.mandatoryAttributes != null) {
            for (String mand : this.mandatoryAttributes) {
                Parameter reqAttributeValue = reqParameters.getAttribute(mand);
                if (reqParameters != null && reqAttributeValue != null) continue;
                validMatch = false;
                break;
            }
        }
        if (validMatch && reqParameters != null && (params = reqParameters.getAttributes()) != null && !params.isEmpty()) {
            for (String name : params.keySet()) {
                String otherValue = (String)reqParameters.getAttributeValue(name, String.class);
                String ourValue = (String)capParameters.getAttributeValue(name, String.class);
                if ("bundle-symbolic-name".equals(name)) {
                    if (!otherValue.equals(osgiMetaData.getBundleSymbolicName())) {
                        validMatch = false;
                    }
                } else if ("bundle-version".equals(name)) {
                    AbstractVersionRange range = AbstractVersionRange.valueOf((String)otherValue);
                    if (!range.isInRange((Object)osgiMetaData.getBundleVersion())) {
                        validMatch = false;
                    }
                } else {
                    if ("specification-version".equals(name) || "version".equals(name)) continue;
                    if (ourValue == null || !ourValue.equals(otherValue)) {
                        validMatch = false;
                    }
                }
                if (validMatch) continue;
                break;
            }
        }
        return validMatch;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof OSGiPackageCapability)) {
            return false;
        }
        return super.equals(obj);
    }

    public String toShortString() {
        if (this.shortString == null) {
            StringBuffer buffer = new StringBuffer(this.bundleState.getCanonicalName() + "[" + this.getName());
            Map attributes = this.metadata.getAttributes();
            Map directives = this.metadata.getDirectives();
            for (Map.Entry entry : directives.entrySet()) {
                buffer.append(";" + (String)entry.getKey() + ":=" + ((Parameter)entry.getValue()).getValue());
            }
            for (Map.Entry entry : attributes.entrySet()) {
                buffer.append(";" + (String)entry.getKey() + "=" + ((Parameter)entry.getValue()).getValue());
            }
            buffer.append("]");
            this.shortString = buffer.toString();
        }
        return this.shortString;
    }

    protected void toString(StringBuffer buffer) {
        buffer.append(this.toShortString());
    }
}

