/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.classloading;

import java.util.Map;
import org.jboss.classloader.spi.ImportType;
import org.jboss.classloading.plugins.metadata.PackageRequirement;
import org.jboss.classloading.spi.dependency.Module;
import org.jboss.classloading.spi.metadata.RequirementWithImportType;
import org.jboss.classloading.spi.version.VersionRange;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.osgi.framework.bundle.AbstractBundleState;
import org.jboss.osgi.framework.bundle.DeployedBundleState;
import org.jboss.osgi.framework.classloading.OSGiRequirement;
import org.jboss.osgi.framework.metadata.PackageAttribute;
import org.jboss.osgi.framework.metadata.Parameter;
import org.jboss.osgi.framework.metadata.internal.AbstractVersionRange;

public class OSGiPackageRequirement
extends PackageRequirement
implements RequirementWithImportType,
OSGiRequirement {
    private static final long serialVersionUID = 5109907232396093061L;
    private AbstractBundleState bundleState;
    private PackageAttribute metadata;
    private String shortString;

    public static OSGiPackageRequirement create(AbstractBundleState bundleState, PackageAttribute metadata, boolean isDynamic) {
        if (bundleState == null) {
            throw new IllegalArgumentException("Null bundle");
        }
        if (metadata == null) {
            throw new IllegalArgumentException("Null require package");
        }
        String name = metadata.getAttribute();
        AbstractVersionRange range = null;
        String versionString = (String)metadata.getAttributeValue("version", String.class);
        if (versionString != null) {
            range = AbstractVersionRange.valueOf((String)versionString);
            String oldVersionString = (String)metadata.getAttributeValue("specification-version", String.class);
            if (oldVersionString != null && !oldVersionString.equals(versionString)) {
                throw new IllegalStateException("version of " + versionString + " does not match " + "specification-version" + " of " + oldVersionString);
            }
        } else {
            versionString = (String)metadata.getAttributeValue("specification-version", String.class);
            if (versionString != null) {
                range = AbstractVersionRange.valueOf((String)versionString);
            }
        }
        return new OSGiPackageRequirement(bundleState, name, (VersionRange)range, metadata, isDynamic);
    }

    private OSGiPackageRequirement(AbstractBundleState bundleState, String name, VersionRange versionRange, PackageAttribute packageAttribute, boolean isDynamic) {
        super(name, versionRange);
        if (bundleState == null) {
            throw new IllegalArgumentException("Null bundleState");
        }
        if (packageAttribute == null) {
            throw new IllegalArgumentException("Null packageAttribute");
        }
        this.bundleState = bundleState;
        this.metadata = packageAttribute;
        String resolution = (String)packageAttribute.getDirectiveValue("resolution", String.class);
        if ("optional".equals(resolution)) {
            this.setOptional(true);
        }
        if (isDynamic) {
            this.setDynamic(true);
        }
    }

    @Override
    public AbstractBundleState getBundleState() {
        return this.bundleState;
    }

    public PackageAttribute getMetadata() {
        return this.metadata;
    }

    public ImportType getImportType() {
        return this.isDynamic() ? ImportType.AFTER : ImportType.BEFORE;
    }

    public Module getModule() {
        DeployedBundleState depBundle;
        DeploymentUnit unit;
        Module module = null;
        if (this.bundleState instanceof DeployedBundleState && (module = (Module)(unit = (depBundle = (DeployedBundleState)this.bundleState).getDeploymentUnit()).getAttachment(Module.class)) == null) {
            throw new IllegalStateException("Cannot obtain module from: " + (Object)((Object)this.bundleState));
        }
        return module;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof OSGiPackageRequirement)) {
            return false;
        }
        return super.equals(obj);
    }

    public String toShortString() {
        if (this.shortString == null) {
            StringBuffer buffer = new StringBuffer(this.bundleState.getCanonicalName() + "[" + this.getName());
            Map attributes = this.metadata.getAttributes();
            Map directives = this.metadata.getDirectives();
            for (Map.Entry entry : directives.entrySet()) {
                buffer.append(";" + (String)entry.getKey() + ":=" + ((Parameter)entry.getValue()).getValue());
            }
            for (Map.Entry entry : attributes.entrySet()) {
                buffer.append(";" + (String)entry.getKey() + "=" + ((Parameter)entry.getValue()).getValue());
            }
            buffer.append("]");
            this.shortString = buffer.toString();
        }
        return this.shortString;
    }

    protected void toString(StringBuffer buffer) {
        buffer.append(this.toShortString());
    }
}

