/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.deployers;

import java.util.List;
import org.jboss.classloader.spi.ClassLoaderDomain;
import org.jboss.classloader.spi.ShutdownPolicy;
import org.jboss.classloading.spi.metadata.CapabilitiesMetaData;
import org.jboss.classloading.spi.metadata.Capability;
import org.jboss.classloading.spi.metadata.ClassLoadingMetaData;
import org.jboss.classloading.spi.metadata.Requirement;
import org.jboss.classloading.spi.metadata.RequirementsMetaData;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.spi.deployer.helpers.AbstractSimpleRealDeployer;
import org.jboss.deployers.structure.spi.ClassLoaderFactory;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.osgi.framework.bundle.AbstractBundleState;
import org.jboss.osgi.framework.bundle.OSGiBundleManager;
import org.jboss.osgi.framework.classloading.OSGiBundleCapability;
import org.jboss.osgi.framework.classloading.OSGiClassLoadingMetaData;
import org.jboss.osgi.framework.classloading.OSGiPackageCapability;
import org.jboss.osgi.framework.classloading.OSGiPackageRequirement;
import org.jboss.osgi.framework.classloading.OSGiRequiredBundleRequirement;
import org.jboss.osgi.framework.metadata.OSGiMetaData;
import org.jboss.osgi.framework.metadata.PackageAttribute;
import org.jboss.osgi.framework.metadata.ParameterizedAttribute;
import org.jboss.osgi.framework.plugins.SystemPackagesPlugin;

public class AbstractClassLoadingDeployer
extends AbstractSimpleRealDeployer<OSGiMetaData> {
    private ClassLoaderDomain domain;
    private ClassLoaderFactory factory;

    public AbstractClassLoadingDeployer() {
        super(OSGiMetaData.class);
        this.addInput(AbstractBundleState.class);
        this.addInput(ClassLoadingMetaData.class);
        this.addOutput(ClassLoadingMetaData.class);
        this.setStage(DeploymentStages.POST_PARSE);
        this.setTopLevelOnly(true);
    }

    public void setDomain(ClassLoaderDomain domain) {
        this.domain = domain;
    }

    public void setFactory(ClassLoaderFactory factory) {
        this.factory = factory;
    }

    public void deploy(DeploymentUnit unit, OSGiMetaData osgiMetaData) throws DeploymentException {
        List dynamicImports;
        List imports;
        List exports;
        if (unit.isAttachmentPresent(ClassLoadingMetaData.class)) {
            return;
        }
        AbstractBundleState bundleState = (AbstractBundleState)((Object)unit.getAttachment(AbstractBundleState.class));
        if (bundleState == null) {
            throw new IllegalStateException("No bundle state");
        }
        OSGiBundleManager bundleManager = bundleState.getBundleManager();
        SystemPackagesPlugin syspackPlugin = bundleManager.getPlugin(SystemPackagesPlugin.class);
        OSGiClassLoadingMetaData classLoadingMetaData = new OSGiClassLoadingMetaData();
        classLoadingMetaData.setName(bundleState.getSymbolicName());
        classLoadingMetaData.setVersion(bundleState.getVersion());
        classLoadingMetaData.setDomain(this.domain.getName());
        classLoadingMetaData.setShutdownPolicy(ShutdownPolicy.GARBAGE_COLLECTION);
        classLoadingMetaData.setJ2seClassLoadingCompliance(false);
        CapabilitiesMetaData capabilities = classLoadingMetaData.getCapabilities();
        RequirementsMetaData requirements = classLoadingMetaData.getRequirements();
        OSGiBundleCapability bundleCapability = OSGiBundleCapability.create(bundleState);
        capabilities.addCapability((Capability)bundleCapability);
        List requireBundles = osgiMetaData.getRequireBundles();
        if (requireBundles != null && !requireBundles.isEmpty()) {
            for (ParameterizedAttribute requireBundle : requireBundles) {
                OSGiRequiredBundleRequirement requirement = OSGiRequiredBundleRequirement.create(bundleState, requireBundle);
                requirements.addRequirement((Requirement)requirement);
            }
        }
        if ((exports = osgiMetaData.getExportPackages()) != null && !exports.isEmpty()) {
            for (PackageAttribute metadata : exports) {
                OSGiPackageCapability packageCapability = OSGiPackageCapability.create(bundleState, metadata);
                capabilities.addCapability((Capability)packageCapability);
            }
        }
        if ((imports = osgiMetaData.getImportPackages()) != null && !imports.isEmpty()) {
            for (PackageAttribute metadata : imports) {
                String packageName = metadata.getAttribute();
                if (syspackPlugin.isSystemPackage(packageName)) continue;
                OSGiPackageRequirement requirement = OSGiPackageRequirement.create(bundleState, metadata, false);
                requirements.addRequirement((Requirement)requirement);
            }
        }
        if ((dynamicImports = osgiMetaData.getDynamicImports()) != null && !dynamicImports.isEmpty()) {
            for (PackageAttribute packageAttribute : dynamicImports) {
                String packageName = packageAttribute.getAttribute();
                if (syspackPlugin.isSystemPackage(packageName)) continue;
                OSGiPackageRequirement requirement = OSGiPackageRequirement.create(bundleState, packageAttribute, true);
                requirements.addRequirement((Requirement)requirement);
            }
        }
        unit.addAttachment(ClassLoadingMetaData.class, (Object)classLoadingMetaData);
        unit.addAttachment("org.jboss.deployment.annotation.metadata.complete", (Object)Boolean.TRUE);
        if (this.factory != null) {
            unit.addAttachment(ClassLoaderFactory.class, (Object)this.factory);
        }
    }
}

