/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.deployers;

import java.lang.reflect.Method;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.spi.deployer.helpers.AbstractRealDeployer;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.osgi.framework.metadata.OSGiMetaData;

public class OSGiDeploymentMetaDataDeployer
extends AbstractRealDeployer {
    private static Class<?> dmdClass;

    public OSGiDeploymentMetaDataDeployer() {
        this.setInput(OSGiMetaData.class);
        this.addInput(dmdClass);
        this.addOutput(dmdClass);
        this.setStage(DeploymentStages.POST_PARSE);
        this.setTopLevelOnly(true);
    }

    protected void internalDeploy(DeploymentUnit unit) throws DeploymentException {
        if (unit.isAttachmentPresent(dmdClass)) {
            return;
        }
        try {
            Object deploymentMetaData = dmdClass.newInstance();
            unit.addAttachment(dmdClass.getName(), deploymentMetaData);
            Method setLazyResolve = dmdClass.getMethod("setLazyResolve", Boolean.TYPE);
            setLazyResolve.invoke(deploymentMetaData, true);
        }
        catch (Exception e) {
            throw DeploymentException.rethrowAsDeploymentException((String)"Error handling depoyment metadata", (Throwable)e);
        }
    }

    static {
        ClassLoader cl = OSGiDeploymentMetaDataDeployer.class.getClassLoader();
        try {
            dmdClass = cl.loadClass("org.jboss.deployers.plugins.classloading.DeploymentMetaData");
        }
        catch (ClassNotFoundException e) {
            try {
                dmdClass = cl.loadClass("org.jboss.deployers.spi.classloading.DeploymentMetaData");
            }
            catch (ClassNotFoundException cnfe) {
                throw new RuntimeException("Cannot load DeploymentMetaData class", cnfe);
            }
        }
    }
}

