/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.deployers;

import org.jboss.classloading.spi.dependency.policy.ClassLoaderPolicyModule;
import org.jboss.classloading.spi.metadata.ClassLoadingMetaData;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.vfs.plugins.classloader.VFSClassLoaderDescribeDeployer;
import org.jboss.osgi.framework.bundle.AbstractBundleState;
import org.jboss.osgi.framework.bundle.OSGiBundleManager;
import org.jboss.osgi.framework.classloading.OSGiClassLoadingMetaData;
import org.jboss.osgi.framework.classloading.OSGiModule;
import org.jboss.osgi.framework.plugins.ResolverPlugin;

public class OSGiModuleDeployer
extends VFSClassLoaderDescribeDeployer {
    protected OSGiBundleManager bundleManager;

    public OSGiModuleDeployer(OSGiBundleManager bundleManager) {
        this.bundleManager = bundleManager;
        this.setRelativeOrder(Integer.MIN_VALUE);
    }

    public void deploy(DeploymentUnit unit, ClassLoadingMetaData metaData) throws DeploymentException {
        super.deploy(unit, metaData);
        AbstractBundleState bundleState = (AbstractBundleState)((Object)unit.getAttachment(AbstractBundleState.class));
        ResolverPlugin resolver = this.bundleManager.getOptionalPlugin(ResolverPlugin.class);
        if (resolver != null && bundleState != null) {
            resolver.addBundle(bundleState);
        }
    }

    public void undeploy(DeploymentUnit unit, ClassLoadingMetaData deployment) {
        if (this.bundleManager != null) {
            AbstractBundleState bundleState = (AbstractBundleState)((Object)unit.getAttachment(AbstractBundleState.class));
            ResolverPlugin bundleResolver = this.bundleManager.getOptionalPlugin(ResolverPlugin.class);
            if (bundleResolver != null && bundleState != null) {
                bundleResolver.removeBundle(bundleState);
            }
        }
        super.undeploy(unit, deployment);
    }

    protected ClassLoaderPolicyModule createModule(DeploymentUnit unit, ClassLoadingMetaData metaData) throws DeploymentException {
        Object module = metaData instanceof OSGiClassLoadingMetaData ? new OSGiModule(unit, metaData) : super.createModule(unit, metaData);
        return module;
    }
}

