/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.deployers;

import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.spi.deployer.helpers.AbstractRealDeployer;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.osgi.framework.bundle.OSGiBundleManager;
import org.jboss.osgi.framework.metadata.OSGiMetaData;
import org.jboss.osgi.framework.metadata.internal.AbstractOSGiMetaData;
import org.jboss.osgi.framework.plugins.StartLevelPlugin;
import org.osgi.framework.Version;

public class OSGiStartLevelMetaDataDeployer
extends AbstractRealDeployer {
    private final OSGiBundleManager bundleManager;

    public OSGiStartLevelMetaDataDeployer(OSGiBundleManager bm) {
        this.bundleManager = bm;
        this.setInput(OSGiMetaData.class);
        this.setStage(DeploymentStages.POST_PARSE);
        this.setTopLevelOnly(true);
    }

    protected void internalDeploy(DeploymentUnit unit) throws DeploymentException {
        StartLevelPlugin slp = this.bundleManager.getOptionalPlugin(StartLevelPlugin.class);
        if (slp == null) {
            return;
        }
        OSGiMetaData md = (OSGiMetaData)unit.getAttachment(OSGiMetaData.class);
        if (md instanceof AbstractOSGiMetaData) {
            AbstractOSGiMetaData amd = (AbstractOSGiMetaData)md;
            int bsl = slp.getInitialBundleStartLevel(md.getBundleSymbolicName(), Version.parseVersion((String)md.getBundleVersion()));
            if (bsl != -1) {
                amd.setInitialStartLevel(bsl);
            }
        }
    }
}

