/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.plugins.internal;

import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.logging.Logger;
import org.jboss.osgi.framework.bundle.AbstractBundleState;
import org.jboss.osgi.framework.bundle.OSGiBundleManager;
import org.jboss.osgi.framework.plugins.AutoInstallPlugin;
import org.jboss.osgi.framework.plugins.internal.AbstractPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

public class AutoInstallPluginImpl
extends AbstractPlugin
implements AutoInstallPlugin {
    final Logger log = Logger.getLogger(AutoInstallPluginImpl.class);
    private List<URL> autoInstall = Collections.emptyList();
    private List<URL> autoStart = Collections.emptyList();
    Map<URL, Bundle> autoBundles = new ConcurrentHashMap<URL, Bundle>();

    public AutoInstallPluginImpl(OSGiBundleManager bundleManager) {
        super(bundleManager);
    }

    public void setAutoInstall(List<URL> autoInstall) {
        this.autoInstall = autoInstall;
    }

    public void setAutoStart(List<URL> autoStart) {
        this.autoStart = autoStart;
    }

    @Override
    public void installBundles() throws BundleException {
        for (URL bundleURL : this.autoStart) {
            this.autoInstall.add(bundleURL);
        }
        for (URL bundleURL : this.autoInstall) {
            AbstractBundleState bundle = this.getBundleManager().installBundle(bundleURL);
            this.autoBundles.put(bundleURL, bundle);
        }
    }

    @Override
    public void startBundles() throws BundleException {
        for (URL bundleURL : this.autoStart) {
            Bundle bundle = this.autoBundles.get(bundleURL);
            if (bundle == null) continue;
            bundle.start();
        }
    }
}

