/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.plugins.internal;

import java.io.File;
import java.io.IOException;
import org.jboss.logging.Logger;
import org.jboss.osgi.framework.bundle.OSGiBundleManager;
import org.jboss.osgi.framework.plugins.BundleStoragePlugin;
import org.jboss.osgi.framework.plugins.internal.AbstractPlugin;
import org.osgi.framework.Bundle;

public class BundleStoragePluginImpl
extends AbstractPlugin
implements BundleStoragePlugin {
    final Logger log = Logger.getLogger(BundleStoragePluginImpl.class);
    private String storageArea;

    public BundleStoragePluginImpl(OSGiBundleManager bundleManager) {
        super(bundleManager);
    }

    @Override
    public void cleanStorage(String propValue) {
        if ("onFirstInit".equals(propValue)) {
            File storage = new File(this.getStorageArea());
            storage.delete();
        }
    }

    @Override
    public File getDataFile(Bundle bundle, String filename) {
        File bundleDir = this.getStorageDir(bundle);
        File dataFile = new File(bundleDir.getAbsolutePath() + "/" + filename);
        dataFile.getParentFile().mkdirs();
        return dataFile;
    }

    @Override
    public File getStorageDir(Bundle bundle) {
        File bundleDir = new File(this.getStorageArea() + "/bundle-" + bundle.getBundleId());
        if (!bundleDir.exists()) {
            bundleDir.mkdirs();
        }
        return bundleDir;
    }

    private String getStorageArea() {
        if (this.storageArea == null) {
            String dirName = this.getBundleManager().getProperty("org.osgi.framework.storage");
            if (dirName == null) {
                try {
                    File tmpFile = File.createTempFile("Constants.FRAMEWORK_STORAGE", null);
                    dirName = tmpFile.getParent();
                    tmpFile.delete();
                }
                catch (IOException ex) {
                    throw new IllegalStateException("Cannot create temp storage file", ex);
                }
            }
            this.storageArea = dirName;
        }
        return this.storageArea;
    }
}

