/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.plugins.internal;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.osgi.framework.plugins.FrameworkProperties;
import org.jboss.util.platform.Java;

public class FrameworkPropertiesImpl
implements FrameworkProperties {
    private static String OSGi_FRAMEWORK_EXECUTIONENVIRONMENT;
    private static String OSGi_FRAMEWORK_LANGUAGE;
    private static String OSGi_FRAMEWORK_OS_NAME;
    private static String OSGi_FRAMEWORK_OS_VERSION;
    private static String OSGi_FRAMEWORK_PROCESSOR;
    private static String OSGi_FRAMEWORK_VENDOR;
    private static String OSGi_FRAMEWORK_VERSION;
    private Map<String, Object> properties = new ConcurrentHashMap<String, Object>();

    public FrameworkPropertiesImpl(Map<String, Object> props) {
        this.setProperties(props);
    }

    @Override
    public void setProperties(Map<String, Object> props) {
        if (props != null) {
            this.properties.putAll(props);
        }
        if (this.getProperty("org.osgi.framework.executionenvironment") == null) {
            this.setProperty("org.osgi.framework.executionenvironment", OSGi_FRAMEWORK_EXECUTIONENVIRONMENT);
        }
        if (this.getProperty("org.osgi.framework.language") == null) {
            this.setProperty("org.osgi.framework.language", OSGi_FRAMEWORK_LANGUAGE);
        }
        if (this.getProperty("org.osgi.framework.os.name") == null) {
            this.setProperty("org.osgi.framework.os.name", OSGi_FRAMEWORK_OS_NAME);
        }
        if (this.getProperty("org.osgi.framework.os.version") == null) {
            this.setProperty("org.osgi.framework.os.version", OSGi_FRAMEWORK_OS_VERSION);
        }
        if (this.getProperty("org.osgi.framework.processor") == null) {
            this.setProperty("org.osgi.framework.processor", OSGi_FRAMEWORK_PROCESSOR);
        }
        if (this.getProperty("org.osgi.framework.vendor") == null) {
            this.setProperty("org.osgi.framework.vendor", OSGi_FRAMEWORK_VENDOR);
        }
        if (this.getProperty("org.osgi.framework.version") == null) {
            this.setProperty("org.osgi.framework.version", OSGi_FRAMEWORK_VERSION);
        }
    }

    @Override
    public String getProperty(String key) {
        Object value = this.properties.get(key);
        if (value == null) {
            value = System.getProperty(key);
        }
        if (!(value instanceof String)) {
            return null;
        }
        return (String)value;
    }

    @Override
    public void setProperty(String key, String value) {
        this.properties.put(key, value);
    }

    static {
        OSGi_FRAMEWORK_LANGUAGE = Locale.getDefault().getISO3Language();
        OSGi_FRAMEWORK_VENDOR = "jboss.org";
        OSGi_FRAMEWORK_VERSION = "1.5";
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                ArrayList<String> execEnvironments = new ArrayList<String>();
                if (Java.isCompatible((int)6)) {
                    execEnvironments.add("J2SE-1.5");
                }
                if (Java.isCompatible((int)7)) {
                    execEnvironments.add("JavaSE-1.6");
                }
                String envlist = ((Object)execEnvironments).toString();
                envlist = envlist.substring(1, envlist.length() - 1);
                OSGi_FRAMEWORK_EXECUTIONENVIRONMENT = envlist;
                OSGi_FRAMEWORK_OS_NAME = System.getProperty("os.name");
                OSGi_FRAMEWORK_OS_VERSION = System.getProperty("os.version");
                OSGi_FRAMEWORK_PROCESSOR = System.getProperty("os.arch");
                System.setProperty("org.osgi.vendor.framework", "org.jboss.osgi.plugins.framework");
                return null;
            }
        });
    }
}

