/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.resolver.felix;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.felix.framework.capabilityset.Capability;
import org.apache.felix.framework.capabilityset.Requirement;
import org.apache.felix.framework.resolver.Module;
import org.apache.felix.framework.resolver.ResolveException;
import org.apache.felix.framework.resolver.Wire;
import org.jboss.logging.Logger;
import org.jboss.osgi.framework.bundle.AbstractBundleState;
import org.jboss.osgi.framework.bundle.DeployedBundleState;
import org.jboss.osgi.framework.bundle.OSGiBundleManager;
import org.jboss.osgi.framework.bundle.OSGiFragmentState;
import org.jboss.osgi.framework.bundle.OSGiSystemState;
import org.jboss.osgi.framework.classloading.OSGiCapability;
import org.jboss.osgi.framework.classloading.OSGiPackageCapability;
import org.jboss.osgi.framework.classloading.OSGiPackageRequirement;
import org.jboss.osgi.framework.classloading.OSGiRequirement;
import org.jboss.osgi.framework.plugins.ResolverPlugin;
import org.jboss.osgi.framework.plugins.internal.AbstractPlugin;
import org.jboss.osgi.framework.resolver.AbstractModule;
import org.jboss.osgi.framework.resolver.AbstractResolverPlugin;
import org.jboss.osgi.framework.resolver.felix.AbstractBundleModule;
import org.jboss.osgi.framework.resolver.felix.DeployedBundleModule;
import org.jboss.osgi.framework.resolver.felix.SystemBundleModule;
import org.osgi.framework.Bundle;

public class FelixResolverPlugin
extends AbstractPlugin
implements ResolverPlugin {
    final Logger log = Logger.getLogger(FelixResolverPlugin.class);
    private JBossResolver resolver = new JBossResolver();

    public FelixResolverPlugin(OSGiBundleManager bundleManager) {
        super(bundleManager);
    }

    @Override
    public void addBundle(Bundle bundle) {
        AbstractModule module = this.resolver.createModule(bundle);
        this.resolver.addModule(module);
        if (bundle.getBundleId() != 0L) {
            DeployedBundleState bundleState = DeployedBundleState.assertBundleState(bundle);
            bundleState.getDeploymentUnit().addAttachment(AbstractModule.class, (Object)module);
        }
    }

    @Override
    public void removeBundle(Bundle bundle) {
        AbstractBundleModule module = this.resolver.getModule(bundle);
        this.resolver.removeModule(module);
        if (bundle.getBundleId() != 0L) {
            DeployedBundleState bundleState = DeployedBundleState.assertBundleState(bundle);
            bundleState.getDeploymentUnit().removeAttachment(AbstractModule.class);
        }
    }

    @Override
    public List<Bundle> resolve(List<Bundle> bundles) {
        ArrayList<Bundle> resolved = new ArrayList<Bundle>();
        for (Bundle bundle : bundles) {
            AbstractBundleModule module = this.resolver.getModule(bundle);
            if (!this.failsafeResolve(module)) continue;
            resolved.add(bundle);
        }
        return Collections.unmodifiableList(resolved);
    }

    @Override
    public OSGiCapability getWiredCapability(OSGiRequirement osgireq) {
        OSGiPackageRequirement packreq;
        AbstractBundleState importer = osgireq.getBundleState();
        AbstractBundleModule impModule = this.resolver.getModule(importer);
        if (!impModule.isResolved() && this.failsafeResolve(impModule)) {
            return this.getWiredCapability(osgireq);
        }
        if (!impModule.isResolved()) {
            return null;
        }
        Requirement req = impModule.getMappedRequirement(osgireq);
        OSGiCapability osgicap = this.getWiredCapability(impModule, req);
        if (osgicap == null && importer.isFragment()) {
            OSGiFragmentState fragState = OSGiFragmentState.assertBundleState(importer);
            AbstractBundleModule hostModule = this.resolver.getModule(fragState.getFragmentHost());
            osgicap = this.getWiredCapability(hostModule, req);
        }
        if (osgicap == null && osgireq instanceof OSGiPackageRequirement && (!(packreq = (OSGiPackageRequirement)osgireq).isDynamic() || packreq.isOptional())) {
            for (OSGiCapability aux : impModule.getOSGiCapabilities()) {
                OSGiPackageCapability packcap;
                if (!(aux instanceof OSGiPackageCapability) || !(packcap = (OSGiPackageCapability)aux).matchNameAndVersion(packreq) || !packcap.matchAttributes(packreq)) continue;
                osgicap = packcap;
                break;
            }
        }
        return osgicap;
    }

    private OSGiCapability getWiredCapability(AbstractBundleModule impModule, Requirement req) {
        OSGiCapability osgicap = null;
        Wire wire = impModule.getWireForRequirement(req);
        if (wire != null) {
            Capability wiredcap = wire.getCapability();
            Bundle expBundle = wire.getExporter().getBundle();
            AbstractBundleModule expModule = this.resolver.getModule(expBundle);
            osgicap = expModule.getMappedCapability(wiredcap);
            if (osgicap == null) {
                throw new IllegalStateException("Cannot find capability mapping for: " + wire);
            }
        }
        return osgicap;
    }

    @Override
    public List<OSGiRequirement> getUnresolvedRequirements(Bundle bundle) {
        ArrayList<OSGiRequirement> result = new ArrayList<OSGiRequirement>();
        AbstractBundleModule module = this.resolver.getModule(bundle);
        for (OSGiRequirement req : module.getOSGiRequirements()) {
            OSGiCapability cap = this.getWiredCapability(req);
            if (cap != null) continue;
            result.add(req);
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public Map<OSGiRequirement, OSGiCapability> getWiring(Bundle bundle) {
        LinkedHashMap<OSGiRequirement, OSGiCapability> result = new LinkedHashMap<OSGiRequirement, OSGiCapability>();
        AbstractBundleModule module = this.resolver.getModule(bundle);
        for (OSGiRequirement req : module.getOSGiRequirements()) {
            OSGiCapability cap = this.getWiredCapability(req);
            result.put(req, cap);
        }
        return Collections.unmodifiableMap(result);
    }

    private boolean failsafeResolve(AbstractModule module) {
        try {
            this.resolver.resolve((Module)module);
            return true;
        }
        catch (ResolveException ex) {
            this.log.debug((Object)("Cannot resolve requirement: " + ex.getRequirement()));
            return false;
        }
    }

    static class JBossResolver
    extends AbstractResolverPlugin {
        private SystemBundleModule sysModule;

        JBossResolver() {
        }

        public boolean acquireGlobalLock() {
            return true;
        }

        public void releaseGlobalLock() {
        }

        public void markBundleResolved(Module module) {
        }

        public AbstractModule createModule(Bundle bundle) {
            if (bundle.getBundleId() == 0L) {
                OSGiSystemState bundleState = OSGiSystemState.assertBundleState(bundle);
                this.sysModule = new SystemBundleModule(bundleState);
                return this.sysModule;
            }
            DeployedBundleState bundleState = DeployedBundleState.assertBundleState(bundle);
            return new DeployedBundleModule(bundleState);
        }

        public AbstractBundleModule getModule(Bundle bundle) {
            AbstractBundleModule result = null;
            if (bundle.getBundleId() == 0L) {
                result = this.sysModule;
            } else {
                DeployedBundleState bundleState = DeployedBundleState.assertBundleState(bundle);
                result = (AbstractBundleModule)((Object)bundleState.getDeploymentUnit().getAttachment(AbstractModule.class));
            }
            if (result == null) {
                throw new IllegalStateException("No module attached to: " + bundle);
            }
            return result;
        }
    }
}

