/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.service.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.management.MBeanServer;
import org.jboss.dependency.plugins.AbstractController;
import org.jboss.dependency.plugins.AbstractControllerContext;
import org.jboss.dependency.plugins.AbstractControllerContextActions;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerContextActions;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.osgi.framework.bundle.OSGiBundleManager;
import org.jboss.osgi.framework.plugins.MicrocontainerServicePlugin;
import org.jboss.osgi.framework.plugins.internal.AbstractServicePlugin;
import org.jboss.osgi.spi.service.MicrocontainerService;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public class MicrocontainerServiceImpl
extends AbstractServicePlugin
implements MicrocontainerServicePlugin {
    private Kernel kernel;
    private ServiceRegistration registration;

    public MicrocontainerServiceImpl(OSGiBundleManager bundleManager) {
        super(bundleManager);
        this.kernel = bundleManager.getKernel();
    }

    @Override
    public void startService() {
        this.installKernelBean("jboss.osgi:service=BundleContext", this.getSystemContext());
        this.registration = this.getSystemContext().registerService(MicrocontainerService.class.getName(), (Object)this, null);
        try {
            String filter = "(objectClass=" + MBeanServer.class.getName() + ")";
            this.getSystemContext().addServiceListener((ServiceListener)new JMXServiceListener(), filter);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            // empty catch block
        }
    }

    @Override
    public void stopService() {
        if (this.registration != null) {
            this.registration.unregister();
            this.registration = null;
        }
    }

    public Object getRegisteredBean(String beanName) {
        ControllerContext context = this.kernel.getController().getInstalledContext((Object)beanName);
        return context != null ? context.getTarget() : null;
    }

    public <T> T getRegisteredBean(Class<T> beanClass, String beanName) {
        Object target = this.getRegisteredBean(beanName);
        if (target == null | !beanClass.isAssignableFrom(target.getClass())) {
            return null;
        }
        return (T)target;
    }

    public List<String> listRegisteredBeans() {
        ArrayList<String> names = new ArrayList<String>();
        AbstractController controller = (AbstractController)this.kernel.getController();
        for (ControllerContext ctx : controller.getAllContexts()) {
            if (!(ctx instanceof KernelControllerContext)) continue;
            names.add(ctx.getName().toString());
        }
        return names;
    }

    private void installKernelBean(String beanName, Object target) {
        KernelController controller = this.kernel.getController();
        AbstractControllerContextActions actions = new AbstractControllerContextActions(new HashMap());
        try {
            controller.install((ControllerContext)new AbstractControllerContext((Object)beanName, (ControllerContextActions)actions, null, target));
        }
        catch (Throwable th) {
            throw new IllegalStateException("Cannot install kernel bean: " + beanName, th);
        }
    }

    private void uninstallKernelBean(String beanName) {
        KernelController controller = this.kernel.getController();
        try {
            controller.uninstall((Object)beanName);
        }
        catch (Throwable th) {
            throw new IllegalStateException("Cannot uninstall kernel bean: " + beanName, th);
        }
    }

    class JMXServiceListener
    implements ServiceListener {
        JMXServiceListener() {
        }

        public void serviceChanged(ServiceEvent event) {
            ServiceReference sref = event.getServiceReference();
            MBeanServer server = (MBeanServer)MicrocontainerServiceImpl.this.getSystemContext().getService(sref);
            int type = event.getType();
            switch (type) {
                case 1: {
                    this.registerMBeanServer(server);
                    break;
                }
                case 4: {
                    this.unregisterMBeanServer(server);
                }
            }
        }

        private void registerMBeanServer(MBeanServer server) {
            if (server != null) {
                MicrocontainerServiceImpl.this.installKernelBean("jboss.osgi:service=MBeanServer", server);
            }
        }

        private void unregisterMBeanServer(MBeanServer server) {
            MicrocontainerServiceImpl.this.uninstallKernelBean("jboss.osgi:service=MBeanServer");
        }
    }
}

