/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.deployment.internal;

import java.io.Serializable;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.spi.util.AttachmentSupport;
import org.jboss.osgi.spi.util.BundleInfo;
import org.jboss.osgi.vfs.VirtualFile;

public class DeploymentImpl
extends AttachmentSupport
implements Deployment,
Serializable {
    private static final long serialVersionUID = 6216977125749367927L;
    private BundleInfo info;
    private Integer startLevel;
    private boolean autoStart;
    private boolean update;

    public DeploymentImpl(BundleInfo info) {
        if (info == null) {
            throw new IllegalArgumentException("Bundle info cannot be null");
        }
        this.info = info;
    }

    public VirtualFile getRoot() {
        return this.info.getRoot();
    }

    public String getLocation() {
        return this.info.getLocation();
    }

    public String getSymbolicName() {
        return this.info.getSymbolicName();
    }

    public String getVersion() {
        return this.info.getVersion().toString();
    }

    public String getManifestHeader(String key) {
        return this.info.getManifestHeader(key);
    }

    public Integer getStartLevel() {
        return this.startLevel;
    }

    public void setStartLevel(Integer startLevel) {
        if (startLevel == null || startLevel < 1) {
            throw new IllegalArgumentException("Start level must be greater than one: " + startLevel);
        }
        this.startLevel = startLevel;
    }

    public boolean isAutoStart() {
        return this.autoStart;
    }

    public void setAutoStart(boolean autoStart) {
        this.autoStart = autoStart;
    }

    public boolean isBundleUpdate() {
        return this.update;
    }

    public void setBundleUpdate(boolean update) {
        this.update = update;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DeploymentImpl)) {
            return false;
        }
        DeploymentImpl other = (DeploymentImpl)obj;
        return this.info.equals((Object)other.info);
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        String symbolicName = this.getSymbolicName();
        String version = this.getVersion();
        String url = this.info.getLocation();
        return "[" + symbolicName + "-" + version + ",url=" + url + "]";
    }
}

