/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.vfs30;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import org.jboss.osgi.vfs.VirtualFile;
import org.jboss.osgi.vfs30.VFSAdaptor30;
import org.jboss.osgi.vfs30.VFSEntryPathsEnumeration;
import org.jboss.osgi.vfs30.VFSFindEntriesEnumeration;
import org.jboss.vfs.TempDir;
import org.jboss.vfs.TempFileProvider;
import org.jboss.vfs.VFSUtils;
import org.jboss.vfs.VirtualJarInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class VirtualFileAdaptor30
implements VirtualFile {
    private org.jboss.vfs.VirtualFile delegate;
    private Closeable mount;
    private TempDir streamDir;
    private File streamFile;

    VirtualFileAdaptor30(org.jboss.vfs.VirtualFile root, Closeable mount) {
        this(root);
        this.mount = mount;
    }

    VirtualFileAdaptor30(org.jboss.vfs.VirtualFile delegate) {
        if (delegate == null) {
            throw new IllegalStateException("Null delegate");
        }
        this.delegate = delegate;
    }

    org.jboss.vfs.VirtualFile getDelegate() {
        return this.delegate;
    }

    public String getName() {
        return this.delegate.getName();
    }

    public String getPathName() {
        return this.delegate.getPathName();
    }

    public boolean isFile() throws IOException {
        return this.delegate.isFile();
    }

    public boolean isDirectory() throws IOException {
        return this.delegate.isDirectory();
    }

    public URL toURL() throws IOException {
        URL url = this.delegate.toURL();
        return url;
    }

    public URL getStreamURL() throws IOException {
        if (this.delegate.isFile()) {
            return this.delegate.toURL();
        }
        if (this.streamFile == null) {
            TempFileProvider tmpProvider = TempFileProvider.create((String)"osgiurl-", null);
            this.streamDir = tmpProvider.createTempDir(this.getName());
            this.streamFile = this.streamDir.getFile(this.getName());
            JarOutputStream jarOut = new JarOutputStream(new FileOutputStream(this.streamFile));
            VirtualJarInputStream jarIn = (VirtualJarInputStream)this.delegate.openStream();
            ZipEntry nextEntry = jarIn.getNextEntry();
            while (nextEntry != null) {
                jarOut.putNextEntry(nextEntry);
                VFSUtils.copyStream((InputStream)jarIn, (OutputStream)jarOut);
                nextEntry = jarIn.getNextEntry();
            }
            jarOut.close();
            jarIn.close();
        }
        return this.streamFile.toURI().toURL();
    }

    public VirtualFile getParent() {
        org.jboss.vfs.VirtualFile parent = this.delegate.getParent();
        return parent != null ? new VirtualFileAdaptor30(parent) : null;
    }

    public VirtualFile getChild(String path) throws IOException {
        org.jboss.vfs.VirtualFile child = this.delegate.getChild(path);
        if (!child.exists()) {
            return null;
        }
        return new VirtualFileAdaptor30(child);
    }

    public List<VirtualFile> getChildrenRecursively() throws IOException {
        ArrayList<VirtualFileAdaptor30> files = new ArrayList<VirtualFileAdaptor30>();
        for (org.jboss.vfs.VirtualFile child : this.delegate.getChildrenRecursively()) {
            files.add(new VirtualFileAdaptor30(child));
        }
        return Collections.unmodifiableList(files);
    }

    public Enumeration<URL> findEntries(String path, String pattern, boolean recurse) throws IOException {
        org.jboss.vfs.VirtualFile child;
        if (path == null) {
            throw new IllegalArgumentException("Null path");
        }
        if (pattern == null) {
            pattern = "*";
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (!(child = this.delegate.getChild(path)).exists()) {
            return null;
        }
        return new VFSFindEntriesEnumeration(this.delegate, child, pattern, recurse);
    }

    public Enumeration<String> getEntryPaths(String path) throws IOException {
        org.jboss.vfs.VirtualFile child;
        if (path == null) {
            throw new IllegalArgumentException("Null path");
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (!(child = this.delegate.getChild(path)).exists()) {
            return null;
        }
        return new VFSEntryPathsEnumeration(this.delegate, child);
    }

    public InputStream openStream() throws IOException {
        if (this.mount != null) {
            return this.getStreamURL().openStream();
        }
        return this.delegate.openStream();
    }

    public void close() {
        VFSUtils.safeClose((Closeable)this.mount);
        VFSAdaptor30.unregister(this);
        if (this.streamFile != null) {
            this.streamFile.delete();
            this.streamFile = null;
        }
        try {
            if (this.streamDir != null) {
                this.streamDir.close();
                this.streamDir = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean equals(Object obj) {
        return this.delegate.equals(obj);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public String toString() {
        return this.delegate.toString();
    }
}

