/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.extender.war.internal;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.lang.PreConditionException;
import org.ops4j.pax.swissbox.extender.BundleObserver;
import org.ops4j.pax.web.extender.war.internal.WebAppPublisher;
import org.ops4j.pax.web.extender.war.internal.WebXmlParser;
import org.ops4j.pax.web.extender.war.internal.model.WebApp;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class WebXmlObserver
implements BundleObserver<URL> {
    private static final Log LOG = LogFactory.getLog(WebXmlObserver.class);
    private final WebXmlParser m_parser;
    private final WebAppPublisher m_publisher;
    private final Map<URL, WebApp> m_publishedWebApps;

    WebXmlObserver(WebXmlParser parser, WebAppPublisher publisher) {
        NullArgumentException.validateNotNull((Object)parser, (String)"Web.xml Parser");
        NullArgumentException.validateNotNull((Object)publisher, (String)"Web App Publisher");
        this.m_parser = parser;
        this.m_publisher = publisher;
        this.m_publishedWebApps = new HashMap<URL, WebApp>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addingEntries(Bundle bundle, List<URL> entries) {
        NullArgumentException.validateNotNull((Object)bundle, (String)"Bundle");
        NullArgumentException.validateNotNull(entries, (String)"List of web.xml's");
        PreConditionException.validateEqualTo((long)1L, (long)entries.size(), (String)"Number of xml's");
        URL webXmlURL = entries.get(0);
        LOG.debug((Object)("Parsing a web application from [" + webXmlURL + "]"));
        InputStream is = null;
        try {
            is = webXmlURL.openStream();
            WebApp webApp = this.m_parser.parse(is);
            if (webApp != null) {
                LOG.debug((Object)("Parsed web app [" + webApp + "]"));
                webApp.setBundle(bundle);
                String contextName = (String)bundle.getHeaders().get("Webapp-Context");
                if (contextName == null) {
                    LOG.debug((Object)"No 'Webapp-Context' manifest attribute specified");
                    String symbolicName = bundle.getSymbolicName();
                    if (symbolicName == null) {
                        contextName = String.valueOf(bundle.getBundleId());
                        LOG.debug((Object)String.format("Using bundle id [%s] as context name", contextName));
                    } else {
                        contextName = symbolicName;
                        LOG.debug((Object)String.format("Using bundle symbolic name [%s] as context name", contextName));
                    }
                }
                if ("/".equals(contextName.trim())) {
                    contextName = "";
                }
                LOG.info((Object)String.format("Using [%s] as web application context name", contextName));
                webApp.setContextName(contextName);
                this.m_publisher.publish(webApp);
                this.m_publishedWebApps.put(webXmlURL, webApp);
            }
        }
        catch (IOException ignore) {
            LOG.error((Object)"Could not parse web.xml", (Throwable)ignore);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ignore) {}
            }
        }
    }

    public void removingEntries(Bundle bundle, List<URL> entries) {
        NullArgumentException.validateNotNull((Object)bundle, (String)"Bundle");
        NullArgumentException.validateNotNull(entries, (String)"List of web.xml's");
        PreConditionException.validateEqualTo((long)1L, (long)entries.size(), (String)"Number of xml's");
        URL webXmlURL = entries.get(0);
        LOG.debug((Object)("Unregistering web application parsed from [" + webXmlURL + "]"));
        WebApp toUnpublish = this.m_publishedWebApps.get(webXmlURL);
        if (toUnpublish != null) {
            this.m_publisher.unpublish(toUnpublish);
        }
    }
}

