/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.metadata;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.jar.Attributes;
import org.jboss.osgi.framework.metadata.internal.AbstractOSGiMetaData;

class DynamicOSGiMetaData
extends AbstractOSGiMetaData
implements Externalizable {
    private Map<Attributes.Name, String> attributes = new LinkedHashMap<Attributes.Name, String>();

    public DynamicOSGiMetaData(String symbolicName) {
        this.addMainAttribute("Bundle-SymbolicName", symbolicName);
        this.addMainAttribute("Bundle-ManifestVersion", "2");
    }

    public void addMainAttribute(String key, String value) {
        this.attributes.put(new Attributes.Name(key), value);
    }

    @Override
    public Map<Attributes.Name, String> getMainAttributes() {
        return Collections.unmodifiableMap(this.attributes);
    }

    @Override
    public String getMainAttribute(String key) {
        return this.getMainAttributes().get(new Attributes.Name(key));
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.attributes);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.attributes = (Map)in.readObject();
    }
}

