/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.metadata;

import java.util.ArrayList;
import java.util.List;
import org.jboss.osgi.framework.metadata.DynamicOSGiMetaData;
import org.jboss.osgi.framework.metadata.OSGiMetaData;

public class OSGiMetaDataBuilder {
    private DynamicOSGiMetaData metadata;
    private List<String> importPackages = new ArrayList<String>();
    private List<String> exportPackages = new ArrayList<String>();
    private List<String> dynamicImportPackages = new ArrayList<String>();

    public static OSGiMetaDataBuilder createBuilder(String symbolicName) {
        return new OSGiMetaDataBuilder(symbolicName);
    }

    private OSGiMetaDataBuilder(String symbolicName) {
        this.metadata = new DynamicOSGiMetaData(symbolicName);
    }

    public OSGiMetaDataBuilder setBundleManifestVersion(int version) {
        this.metadata.addMainAttribute("Bundle-ManifestVersion", "" + version);
        return this;
    }

    public OSGiMetaDataBuilder setBundleActivator(String value) {
        this.metadata.addMainAttribute("Bundle-Activator", value);
        return this;
    }

    public OSGiMetaDataBuilder addImportPackages(Class<?> ... packages) {
        for (Class<?> aux : packages) {
            this.addImportPackages(aux.getPackage().getName());
        }
        return this;
    }

    public OSGiMetaDataBuilder addImportPackages(String ... packages) {
        for (String aux : packages) {
            this.importPackages.add(aux);
        }
        return this;
    }

    public OSGiMetaDataBuilder addExportPackages(Class<?> ... packages) {
        for (Class<?> aux : packages) {
            this.addExportPackages(aux.getPackage().getName());
        }
        return this;
    }

    public OSGiMetaDataBuilder addExportPackages(String ... packages) {
        for (String aux : packages) {
            this.exportPackages.add(aux);
        }
        return this;
    }

    public OSGiMetaDataBuilder addDynamicImportPackages(Class<?> ... packages) {
        for (Class<?> aux : packages) {
            this.addDynamicImportPackages(aux.getPackage().getName());
        }
        return this;
    }

    public OSGiMetaDataBuilder addDynamicImportPackages(String ... packages) {
        for (String aux : packages) {
            this.dynamicImportPackages.add(aux);
        }
        return this;
    }

    public OSGiMetaDataBuilder addMainAttribute(String key, String value) {
        this.metadata.addMainAttribute(key, value);
        return this;
    }

    public OSGiMetaData getOSGiMetaData() {
        int i;
        StringBuffer value;
        if (this.exportPackages.size() > 0) {
            value = new StringBuffer();
            for (i = 0; i < this.exportPackages.size(); ++i) {
                value.append(i > 0 ? "," : "");
                value.append(this.exportPackages.get(i));
            }
            this.metadata.addMainAttribute("Export-Package", value.toString());
        }
        if (this.importPackages.size() > 0) {
            value = new StringBuffer();
            for (i = 0; i < this.importPackages.size(); ++i) {
                value.append(i > 0 ? "," : "");
                value.append(this.importPackages.get(i));
            }
            this.metadata.addMainAttribute("Import-Package", value.toString());
        }
        if (this.dynamicImportPackages.size() > 0) {
            value = new StringBuffer();
            for (i = 0; i < this.dynamicImportPackages.size(); ++i) {
                value.append(i > 0 ? "," : "");
                value.append(this.dynamicImportPackages.get(i));
            }
            this.metadata.addMainAttribute("DynamicImport-Package", value.toString());
        }
        return this.metadata;
    }
}

