/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.metadata.internal;

import java.net.URL;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.Attributes;
import org.jboss.classloading.spi.version.VersionComparator;
import org.jboss.classloading.spi.version.VersionComparatorRegistry;
import org.jboss.osgi.framework.metadata.ActivationPolicyMetaData;
import org.jboss.osgi.framework.metadata.CaseInsensitiveDictionary;
import org.jboss.osgi.framework.metadata.OSGiMetaData;
import org.jboss.osgi.framework.metadata.PackageAttribute;
import org.jboss.osgi.framework.metadata.ParameterizedAttribute;
import org.jboss.osgi.framework.metadata.internal.AbstractVersionRange;
import org.jboss.osgi.framework.metadata.internal.ValueCreator;
import org.jboss.osgi.framework.metadata.internal.ValueCreatorUtil;
import org.osgi.framework.Version;

public abstract class AbstractOSGiMetaData
implements OSGiMetaData {
    private static final long serialVersionUID = 1L;
    private static final int START_LEVEL_NOT_DEFINED = -1;
    protected transient Map<String, Object> cachedAttributes = new ConcurrentHashMap<String, Object>();
    protected transient ParameterizedAttribute parameters;
    protected transient int initialStartLevel = -1;

    protected abstract Map<Attributes.Name, String> getMainAttributes();

    protected abstract String getMainAttribute(String var1);

    @Override
    public Dictionary<String, String> getHeaders() {
        Map<Attributes.Name, String> attributes = this.getMainAttributes();
        Hashtable<String, String> result = new Hashtable<String, String>();
        for (Map.Entry<Attributes.Name, String> entry : attributes.entrySet()) {
            ((Dictionary)result).put(entry.getKey().toString(), entry.getValue());
        }
        return new CaseInsensitiveDictionary(result);
    }

    @Override
    public String getHeader(String key) {
        return this.get(key, ValueCreatorUtil.STRING_VC);
    }

    @Override
    public ActivationPolicyMetaData getBundleActivationPolicy() {
        return this.get("Bundle-ActivationPolicy", ValueCreatorUtil.ACTIVATION_POLICY_VC);
    }

    @Override
    public String getBundleActivator() {
        return this.get("Bundle-Activator", ValueCreatorUtil.STRING_VC);
    }

    @Override
    public List<String> getBundleCategory() {
        return this.get("Bundle-Category", ValueCreatorUtil.STRING_LIST_VC);
    }

    @Override
    public List<String> getBundleClassPath() {
        return this.get("Bundle-ClassPath", ValueCreatorUtil.STRING_LIST_VC, Arrays.asList("."));
    }

    @Override
    public String getBundleDescription() {
        return this.get("Bundle-Description", ValueCreatorUtil.STRING_VC);
    }

    @Override
    public String getBundleLocalization() {
        return this.get("Bundle-Localization", ValueCreatorUtil.STRING_VC, "OSGI-INF/l10n/bundle");
    }

    @Override
    public int getBundleManifestVersion() {
        return this.get("Bundle-ManifestVersion", ValueCreatorUtil.INTEGER_VC, 1);
    }

    @Override
    public String getBundleName() {
        return this.get("Bundle-Name", ValueCreatorUtil.STRING_VC);
    }

    @Override
    public List<ParameterizedAttribute> getBundleNativeCode() {
        return this.get("Bundle-NativeCode", ValueCreatorUtil.PATH_ATTRIB_LIST_VC);
    }

    @Override
    public List<String> getRequiredExecutionEnvironment() {
        return this.get("Bundle-RequiredExecutionEnvironment", ValueCreatorUtil.STRING_LIST_VC);
    }

    @Override
    public String getBundleSymbolicName() {
        String symbolicName = null;
        ParameterizedAttribute parameters = this.parseSymbolicName();
        if (parameters != null) {
            symbolicName = parameters.getAttribute();
        }
        return symbolicName;
    }

    @Override
    public ParameterizedAttribute getBundleParameters() {
        return this.parseSymbolicName();
    }

    @Override
    public URL getBundleUpdateLocation() {
        return this.get("Bundle-UpdateLocation", ValueCreatorUtil.URL_VC);
    }

    @Override
    public String getBundleVersion() {
        return this.get("Bundle-Version", ValueCreatorUtil.STRING_VC, "0.0.0");
    }

    @Override
    public List<PackageAttribute> getDynamicImports() {
        return this.get("DynamicImport-Package", ValueCreatorUtil.PACKAGE_LIST_VC);
    }

    @Override
    public List<PackageAttribute> getExportPackages() {
        return this.get("Export-Package", ValueCreatorUtil.PACKAGE_LIST_VC);
    }

    @Override
    public ParameterizedAttribute getFragmentHost() {
        return this.get("Fragment-Host", ValueCreatorUtil.PARAM_ATTRIB_VC);
    }

    @Override
    public List<PackageAttribute> getImportPackages() {
        return this.get("Import-Package", ValueCreatorUtil.PACKAGE_LIST_VC);
    }

    @Override
    public List<ParameterizedAttribute> getRequireBundles() {
        return this.get("Require-Bundle", ValueCreatorUtil.QNAME_ATTRIB_LIST_VC);
    }

    @Override
    public boolean isSingleton() {
        this.parseSymbolicName();
        if (this.parameters == null) {
            return false;
        }
        return "true".equals(this.parameters.getDirectiveValue("singleton", String.class));
    }

    @Override
    public String getFragmentAttachment() {
        this.parseSymbolicName();
        if (this.parameters == null) {
            return null;
        }
        return this.parameters.getDirectiveValue("fragment-attachment", String.class);
    }

    protected ParameterizedAttribute parseSymbolicName() {
        if (this.parameters == null) {
            List<ParameterizedAttribute> parsed = this.get("Bundle-SymbolicName", ValueCreatorUtil.QNAME_ATTRIB_LIST_VC);
            if (parsed == null || parsed.size() != 1) {
                return null;
            }
            this.parameters = parsed.get(0);
        }
        return this.parameters;
    }

    protected <T> T get(String key, ValueCreator<T> creator) {
        return this.get(key, creator, null);
    }

    protected <T> T get(String key, ValueCreator<T> creator, T defaultValue) {
        Object value = this.cachedAttributes.get(key);
        if (value == null) {
            String attribute = this.getMainAttribute(key);
            if (attribute != null) {
                value = creator.createValue(attribute);
            } else if (defaultValue != null) {
                value = defaultValue;
            }
            if (value != null) {
                this.cachedAttributes.put(key, value);
            }
        }
        return (T)value;
    }

    @Override
    public int getInitialStartLevel() {
        return this.initialStartLevel;
    }

    public void setInitialStartLevel(int sl) {
        this.initialStartLevel = sl;
    }

    static {
        VersionComparatorRegistry registry = VersionComparatorRegistry.getInstance();
        registry.registerVersionComparator(Version.class, Version.class, (VersionComparator)new AbstractVersionRange.OSGiVersionToOSGiVersionComparator());
        registry.registerVersionComparator(Version.class, org.jboss.classloading.spi.version.Version.class, (VersionComparator)new AbstractVersionRange.OSGiVersionToVersionComparator());
        registry.registerVersionComparator(Version.class, String.class, (VersionComparator)new AbstractVersionRange.OSGiVersionToStringComparator());
    }
}

