/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.jmx.internal;

import java.io.IOException;
import javax.management.MBeanServer;
import javax.management.remote.JMXServiceURL;
import org.jboss.logging.Logger;
import org.jboss.osgi.jmx.JMXServiceURLFactory;
import org.jboss.osgi.jmx.internal.BundleStateExt;
import org.jboss.osgi.jmx.internal.FrameworkStateExt;
import org.jboss.osgi.jmx.internal.JMXConnectorService;
import org.jboss.osgi.jmx.internal.MBeanServerService;
import org.jboss.osgi.jmx.internal.PackageStateExt;
import org.jboss.osgi.jmx.internal.ServiceStateExt;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class JMXServiceActivator
implements BundleActivator {
    private static final Logger log = Logger.getLogger(JMXServiceActivator.class);
    private JMXConnectorService jmxConnector;
    private String jmxHost;
    private String jmxPortStr;
    private String rmiPortStr;
    private MBeanServer mbeanServer;
    private FrameworkStateExt frameworkState;
    private ServiceStateExt serviceState;
    private BundleStateExt bundleState;
    private PackageStateExt packageState;

    public void start(BundleContext context) {
        MBeanServerService service = new MBeanServerService(context);
        this.mbeanServer = service.registerMBeanServer();
        BundleContext sysContext = context.getBundle(0L).getBundleContext();
        this.frameworkState = new FrameworkStateExt(sysContext, this.mbeanServer);
        this.frameworkState.start();
        this.serviceState = new ServiceStateExt(sysContext, this.mbeanServer);
        this.serviceState.start();
        this.bundleState = new BundleStateExt(sysContext, this.mbeanServer);
        this.bundleState.start();
        this.packageState = new PackageStateExt(sysContext, this.mbeanServer);
        this.packageState.start();
        this.jmxHost = context.getProperty("org.jboss.osgi.jmx.host");
        if (this.jmxHost == null) {
            this.jmxHost = "localhost";
        }
        this.jmxPortStr = context.getProperty("org.jboss.osgi.jmx.rmi.port");
        if (this.jmxPortStr == null) {
            this.jmxPortStr = "1198";
        }
        this.rmiPortStr = context.getProperty("org.jboss.osgi.jmx.rmi.registry.port");
        if (this.rmiPortStr == null) {
            this.rmiPortStr = "1090";
        }
        int jmxPort = Integer.parseInt(this.jmxPortStr);
        int rmiPort = Integer.parseInt(this.rmiPortStr);
        JMXServiceURL serviceURL = JMXServiceURLFactory.getServiceURL(this.jmxHost, jmxPort, rmiPort);
        try {
            this.jmxConnector = new JMXConnectorService(serviceURL, rmiPort);
            this.jmxConnector.start(this.mbeanServer);
        }
        catch (IOException ex) {
            log.error((Object)("Cannot start JMXConnectorServer on: " + serviceURL), (Throwable)ex);
        }
    }

    public void stop(BundleContext context) {
        this.frameworkState.stop();
        this.serviceState.stop();
        this.bundleState.stop();
        this.packageState.stop();
        if (this.jmxConnector != null) {
            this.jmxConnector.stop();
            this.jmxConnector = null;
        }
    }
}

