/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import javax.ws.rs.HttpMethod;
import javax.ws.rs.Path;
import org.jboss.resteasy.util.AnnotationResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetRestful {
    public static Class getRootResourceClass(Class clazz) {
        return AnnotationResolver.getClassWithAnnotation(clazz, Path.class);
    }

    public static Class getSubResourceClass(Class clazz) {
        Class actualClass = clazz;
        while (GetRestful.isTopObject(actualClass)) {
            if (GetRestful.hasJAXRSAnnotations(actualClass)) {
                return actualClass;
            }
            actualClass = actualClass.getSuperclass();
        }
        for (Class<?> intf : clazz.getInterfaces()) {
            if (!GetRestful.hasJAXRSAnnotations(intf)) continue;
            return intf;
        }
        return null;
    }

    private static boolean isTopObject(Class<?> actualClass) {
        return actualClass != null && actualClass != Object.class;
    }

    private static boolean hasJAXRSAnnotations(Class<?> c) {
        if (c.isAnnotationPresent(Path.class)) {
            return true;
        }
        for (Method method : c.getMethods()) {
            if (method.isAnnotationPresent(Path.class)) {
                return true;
            }
            for (Annotation ann : method.getAnnotations()) {
                if (!ann.annotationType().isAnnotationPresent(HttpMethod.class)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isRootResource(Class clazz) {
        return GetRestful.getRootResourceClass(clazz) != null;
    }
}

