/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.conversation;

import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.jboss.weld.context.ConversationContext;
import org.jboss.weld.context.api.BeanStore;
import org.jboss.weld.conversation.ConversationImpl;
import org.jboss.weld.logging.Category;
import org.jboss.weld.logging.LoggerFactory;
import org.jboss.weld.logging.messages.ConversationMessage;
import org.slf4j.cal10n.LocLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagedConversation {
    private static final LocLogger log = LoggerFactory.loggerFactory().getLogger(Category.CONVERSATION);
    private ConversationImpl conversation;
    private Future<?> terminationHandle;
    private ReentrantLock concurrencyLock;
    private BeanStore beanStore;
    private long touched;

    protected ManagedConversation(ConversationImpl conversation, BeanStore beanStore, Future<?> terminationHandle) {
        this.conversation = conversation;
        this.beanStore = beanStore;
        this.terminationHandle = terminationHandle;
        this.concurrencyLock = new ReentrantLock();
        this.touch();
    }

    public static ManagedConversation of(ConversationImpl conversation, BeanStore beanStore, Future<?> terminationHandle) {
        return new ManagedConversation(conversation, beanStore, terminationHandle);
    }

    public static ManagedConversation of(ConversationImpl conversation, BeanStore beanStore) {
        return ManagedConversation.of(conversation, beanStore, null);
    }

    public boolean cancelTermination() {
        if (this.terminationHandle == null) {
            return false;
        }
        if (this.terminationHandle.isCancelled()) {
            return true;
        }
        boolean success = this.terminationHandle.cancel(false);
        if (success) {
            log.trace((Enum)ConversationMessage.CONVERSATION_TERMINATION_CANCELLED, new Object[]{this.conversation});
        } else {
            log.warn((Enum)ConversationMessage.CONVERSATION_TERMINATION_CANCELLATION_FAILED, new Object[]{this.conversation});
        }
        return success;
    }

    public void destroy() {
        if (this.terminationHandle != null && !this.terminationHandle.isCancelled()) {
            this.cancelTermination();
        }
        ConversationContext.destroyBeanStore(this.beanStore);
    }

    public boolean lock(long timeout) throws InterruptedException {
        boolean success = this.concurrencyLock.tryLock(timeout, TimeUnit.MILLISECONDS);
        if (success) {
            log.trace((Enum)ConversationMessage.CONVERSATION_LOCKED, new Object[]{this.conversation});
        } else {
            log.warn((Enum)ConversationMessage.CONVERSATION_UNAVAILBLE, new Object[]{timeout, this.conversation});
        }
        return success;
    }

    public boolean unlock() {
        if (!this.concurrencyLock.isLocked()) {
            return true;
        }
        if (this.concurrencyLock.isHeldByCurrentThread()) {
            this.concurrencyLock.unlock();
            log.trace((Enum)ConversationMessage.CONVERSATION_UNLOCKED, new Object[]{this.conversation});
        } else {
            log.warn((Enum)ConversationMessage.ILLEGAL_CONVERSATION_UNLOCK_ATTEMPT, new Object[]{this.conversation, "not owner"});
        }
        return !this.concurrencyLock.isLocked();
    }

    public void setTerminationHandle(Future<?> terminationHandle) {
        this.terminationHandle = terminationHandle;
    }

    public ConversationImpl getConversation() {
        return this.conversation;
    }

    public boolean isExpired() {
        return System.currentTimeMillis() > this.touched + this.conversation.getTimeout();
    }

    public void touch() {
        this.touched = System.currentTimeMillis();
    }
}

