/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.util.bytecode;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DescriptorUtils {
    private static String extToInt(String className) {
        String repl = className.replace(".", "/");
        return 'L' + repl + ';';
    }

    public static String[] descriptorStringToParameterArray(String methodDescriptor) {
        int i = 1;
        ArrayList<String> ret = new ArrayList<String>();
        int arraystart = -1;
        while (methodDescriptor.charAt(i) != ')') {
            String type = null;
            if (methodDescriptor.charAt(i) == '[') {
                if (arraystart == -1) {
                    arraystart = i;
                }
            } else {
                if (methodDescriptor.charAt(i) == 'L') {
                    int start = i++;
                    while (methodDescriptor.charAt(i) != ';') {
                        ++i;
                    }
                    type = arraystart == -1 ? methodDescriptor.substring(start, i) : methodDescriptor.substring(arraystart, i);
                } else {
                    type = arraystart == -1 ? methodDescriptor.charAt(i) + "" : methodDescriptor.substring(arraystart, i + 1);
                }
                arraystart = -1;
                ret.add(type);
            }
            ++i;
        }
        String[] r = new String[ret.size()];
        for (int j = 0; j < ret.size(); ++j) {
            r[j] = (String)ret.get(j);
        }
        return r;
    }

    public static String classToStringRepresentation(Class<?> c) {
        if (Void.TYPE.equals(c)) {
            return "V";
        }
        if (Byte.TYPE.equals(c)) {
            return "B";
        }
        if (Character.TYPE.equals(c)) {
            return "C";
        }
        if (Double.TYPE.equals(c)) {
            return "D";
        }
        if (Float.TYPE.equals(c)) {
            return "F";
        }
        if (Integer.TYPE.equals(c)) {
            return "I";
        }
        if (Long.TYPE.equals(c)) {
            return "J";
        }
        if (Short.TYPE.equals(c)) {
            return "S";
        }
        if (Boolean.TYPE.equals(c)) {
            return "Z";
        }
        if (c.isArray()) {
            return c.getName().replace(".", "/");
        }
        return DescriptorUtils.extToInt(c.getName());
    }

    public static boolean isPrimitive(String descriptor) {
        return descriptor.length() == 1;
    }

    public static boolean isWide(String descriptor) {
        if (!DescriptorUtils.isPrimitive(descriptor)) {
            return false;
        }
        char c = descriptor.charAt(0);
        return c == 'D' || c == 'J';
    }

    public static boolean isWide(Class<?> cls) {
        return cls == Double.TYPE || cls == Long.TYPE;
    }

    public static String getConstructorDescriptor(Constructor<?> c) {
        StringBuilder desc = new StringBuilder("(");
        for (Class<?> p : c.getParameterTypes()) {
            desc.append(DescriptorUtils.classToStringRepresentation(p));
        }
        desc.append(")");
        desc.append("V");
        return desc.toString();
    }

    public static String getMethodDescriptor(Method m) {
        StringBuilder desc = new StringBuilder("(");
        for (Class<?> p : m.getParameterTypes()) {
            desc.append(DescriptorUtils.classToStringRepresentation(p));
        }
        desc.append(")");
        desc.append(DescriptorUtils.classToStringRepresentation(m.getReturnType()));
        return desc.toString();
    }
}

