/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.integration.deployer.env;

import java.net.URL;
import java.util.Collection;
import org.jboss.classloading.spi.dependency.Module;
import org.jboss.classloading.spi.visitor.ClassFilter;
import org.jboss.classloading.spi.visitor.ResourceContext;
import org.jboss.classloading.spi.visitor.ResourceFilter;
import org.jboss.classloading.spi.visitor.ResourceVisitor;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.vfs.spi.deployer.AbstractOptionalVFSRealDeployer;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.util.NotImplementedException;
import org.jboss.vfs.VirtualFile;
import org.jboss.weld.integration.deployer.env.WeldDiscoveryEnvironment;
import org.jboss.weld.integration.deployer.env.bda.ArchiveInfo;
import org.jboss.weld.integration.deployer.ext.JBossWeldMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArchiveDiscoveryDeployer
extends AbstractOptionalVFSRealDeployer<JBossWeldMetaData> {
    public ArchiveDiscoveryDeployer() {
        super(JBossWeldMetaData.class);
        this.addInput("WELD_FILES");
        this.addInput("WELD_CLASSPATH");
        this.addInput(ArchiveInfo.class);
        this.addOutput(ArchiveInfo.class);
        this.setStage(DeploymentStages.PRE_REAL);
    }

    public void deploy(VFSDeploymentUnit unit, JBossWeldMetaData deployment) throws DeploymentException {
        boolean hasCp;
        Collection wbFiles = (Collection)unit.getAttachment("WELD_FILES", Collection.class);
        boolean hasWB = wbFiles != null && !wbFiles.isEmpty();
        Collection cpFiles = (Collection)unit.getAttachment("WELD_CLASSPATH", Collection.class);
        boolean bl = hasCp = cpFiles != null && !cpFiles.isEmpty();
        if (!hasWB && !hasCp) {
            return;
        }
        try {
            ArchiveInfo archive = null;
            if (hasCp) {
                VFSDeploymentUnit moduleUnit;
                Module module = (Module)moduleUnit.getAttachment(Module.class);
                for (moduleUnit = unit; moduleUnit != null && module == null; moduleUnit = moduleUnit.getParent()) {
                    module = (Module)moduleUnit.getAttachment(Module.class);
                }
                if (module == null) {
                    throw new DeploymentException("No module in deployment unit's hierarchy: " + unit.getName());
                }
                URL[] urls = new URL[cpFiles.size()];
                int i = 0;
                for (VirtualFile file : cpFiles) {
                    urls[i++] = file.toURL();
                }
                archive = (ArchiveInfo)moduleUnit.getAttachment(ArchiveInfo.class);
                if (archive == null) {
                    throw new IllegalStateException("Archive attachment expected for unit " + unit);
                }
                WeldDiscoveryEnvironment environment = archive.getEnvironment();
                WBDiscoveryVisitor visitor = new WBDiscoveryVisitor(environment);
                module.visit((ResourceVisitor)visitor, (ResourceFilter)ClassFilter.INSTANCE, null, urls);
                if (hasWB) {
                    for (VirtualFile file : wbFiles) {
                        environment.addWeldXmlURL(file.toURL());
                    }
                }
            } else if (hasWB) {
                throw new NotImplementedException();
            }
        }
        catch (Exception e) {
            throw DeploymentException.rethrowAsDeploymentException((String)"Cannot build WB env.", (Throwable)e);
        }
    }

    static class WBDiscoveryVisitor
    implements ResourceVisitor {
        private WeldDiscoveryEnvironment wbdi;

        WBDiscoveryVisitor(WeldDiscoveryEnvironment wbdi) {
            this.wbdi = wbdi;
        }

        public ResourceFilter getFilter() {
            return ClassFilter.INSTANCE;
        }

        public void visit(ResourceContext resource) {
            this.wbdi.addWeldClass(resource.getClassName());
        }
    }
}

