/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.integration.deployer;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.jboss.classloading.spi.RealClassLoader;
import org.jboss.weld.bean.proxy.util.SimpleProxyServices;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossProxyServices
extends SimpleProxyServices {
    public ClassLoader getClassLoader(final Class<?> proxiedBeanType) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    return JBossProxyServices.this._getClassLoader(proxiedBeanType);
                }
            });
        }
        return this._getClassLoader(proxiedBeanType);
    }

    private ClassLoader _getClassLoader(Class<?> proxiedBeanType) {
        ClassLoader threadContextClassLoader;
        ClassLoader actualClassLoader;
        for (actualClassLoader = threadContextClassLoader = JBossProxyServices.getThreadContextClassLoader(); actualClassLoader != null && !(actualClassLoader instanceof RealClassLoader); actualClassLoader = actualClassLoader.getParent()) {
        }
        if (actualClassLoader != null) {
            return actualClassLoader;
        }
        if (threadContextClassLoader != null) {
            return threadContextClassLoader;
        }
        return super.getClassLoader(proxiedBeanType);
    }

    private static ClassLoader getThreadContextClassLoader() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    return Thread.currentThread().getContextClassLoader();
                }
            });
        }
        return Thread.currentThread().getContextClassLoader();
    }
}

