/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.integration.deployer.jndi;

import javax.enterprise.inject.spi.BeanManager;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.structure.spi.DeploymentUnitVisitor;
import org.jboss.naming.Util;
import org.jboss.reloaded.naming.deployers.javaee.JavaEEModuleInformer;
import org.jboss.reloaded.naming.service.NameSpaces;
import org.jboss.weld.integration.deployer.DeployersUtils;
import org.jboss.weld.integration.util.IdFactory;

public class JndiBinder {
    public static final String BEAN_MANAGER_JNDI_SUBCONTEXT = "cdi";
    public static final String REFADDR_ID = "id";
    private Context beanManagerContext;
    private NameSpaces nameSpaces;
    private JavaEEModuleInformer moduleInformer;

    public void setModuleInformer(JavaEEModuleInformer moduleInformer) {
        this.moduleInformer = moduleInformer;
    }

    public void setNameSpaces(NameSpaces nameSpaces) {
        this.nameSpaces = nameSpaces;
    }

    public void bind(DeploymentUnit unit) throws DeploymentException {
        if (DeployersUtils.checkForWeldFilesAcrossDeployment(unit)) {
            unit.visit((DeploymentUnitVisitor)new BinderVisitor(this.getBeanManagerContext()));
        }
    }

    public void unbind(DeploymentUnit unit) {
        BeanMetaData bbBMD = (BeanMetaData)unit.getTopLevel().getAttachment(DeployersUtils.getBootstrapBeanAttachmentName(unit), BeanMetaData.class);
        if (bbBMD != null) {
            try {
                unit.visit((DeploymentUnitVisitor)new UnbinderVisitor(this.getBeanManagerContext()));
            }
            catch (DeploymentException e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected Context createContext() throws NamingException {
        return this.nameSpaces.getGlobalContext();
    }

    public void create() throws Exception {
        Context context = this.createContext();
        this.beanManagerContext = context.createSubcontext(BEAN_MANAGER_JNDI_SUBCONTEXT);
    }

    protected Context getBeanManagerContext() {
        return this.beanManagerContext;
    }

    public void destroy() {
        try {
            Context context = this.createContext();
            context.destroySubcontext(BEAN_MANAGER_JNDI_SUBCONTEXT);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean hasJndiBoundBeanManager(DeploymentUnit deploymentUnit) {
        return DeployersUtils.checkForWeldFiles(deploymentUnit, false) && (this.moduleInformer.getModuleType(deploymentUnit).equals((Object)JavaEEModuleInformer.ModuleType.EJB) || this.moduleInformer.getModuleType(deploymentUnit).equals((Object)JavaEEModuleInformer.ModuleType.WEB));
    }

    private String getJndiPath(DeploymentUnit deploymentUnit) {
        String applicationName = this.moduleInformer.getApplicationName(deploymentUnit);
        String path = applicationName == null ? "" : applicationName + "/";
        path = path + this.moduleInformer.getModuleName(deploymentUnit);
        return path;
    }

    private class UnbinderVisitor
    implements DeploymentUnitVisitor {
        private final Context rootContext;

        private UnbinderVisitor(Context rootContext) {
            this.rootContext = rootContext;
        }

        public void visit(DeploymentUnit unit) throws DeploymentException {
            try {
                if (JndiBinder.this.hasJndiBoundBeanManager(unit)) {
                    String path = JndiBinder.this.getJndiPath(unit);
                    Context subcontext = (Context)this.rootContext.lookup(path);
                    subcontext.unbind("BeanManager");
                    this.rootContext.destroySubcontext(path);
                }
            }
            catch (NamingException e) {
                throw new DeploymentException((Throwable)e);
            }
        }

        public void error(DeploymentUnit unit) {
        }
    }

    private class BinderVisitor
    implements DeploymentUnitVisitor {
        private final Context rootContext;

        private BinderVisitor(Context rootContext) {
            this.rootContext = rootContext;
        }

        public void visit(DeploymentUnit unit) throws DeploymentException {
            try {
                if (JndiBinder.this.hasJndiBoundBeanManager(unit)) {
                    String path = JndiBinder.this.getJndiPath(unit);
                    Context subcontext = Util.createSubcontext((Context)this.rootContext, (String)path);
                    Reference reference = new Reference(BeanManager.class.getName(), "org.jboss.weld.integration.deployer.jndi.JBossBeanManagerObjectFactory", null);
                    reference.add(new StringRefAddr(JndiBinder.REFADDR_ID, IdFactory.getIdFromClassLoader(unit.getClassLoader())));
                    subcontext.bind("BeanManager", (Object)reference);
                }
            }
            catch (NamingException e) {
                throw new DeploymentException((Throwable)e);
            }
        }

        public void error(DeploymentUnit unit) {
        }
    }
}

