/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.context.conversation;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import javax.enterprise.context.ContextNotActiveException;
import org.jboss.weld.Container;
import org.jboss.weld.context.ConversationContext;
import org.jboss.weld.context.ManagedConversation;
import org.jboss.weld.exceptions.IllegalStateException;
import org.jboss.weld.logging.Category;
import org.jboss.weld.logging.LoggerFactory;
import org.jboss.weld.logging.messages.ConversationMessage;
import org.slf4j.cal10n.LocLogger;

public class ConversationImpl
implements ManagedConversation,
Serializable {
    private static final long serialVersionUID = 8873338254645033645L;
    private static final LocLogger log = LoggerFactory.loggerFactory().getLogger(Category.CONVERSATION);
    private String id;
    private boolean _transient = true;
    private long timeout;
    private ReentrantLock concurrencyLock;
    private long lastUsed;

    public ConversationImpl() {
        ConversationContext conversationContext = this.getConversationContext();
        this.timeout = conversationContext != null ? conversationContext.getDefaultTimeout() : 0L;
        this.concurrencyLock = new ReentrantLock();
        this.touch();
    }

    private ConversationContext getConversationContext() {
        for (ConversationContext conversationContext : Container.instance().deploymentManager().instance().select(ConversationContext.class, new Annotation[0])) {
            if (!conversationContext.isActive()) continue;
            return conversationContext;
        }
        return null;
    }

    public void begin() {
        this.verifyConversationContextActive();
        if (!this._transient) {
            throw new IllegalStateException(ConversationMessage.BEGIN_CALLED_ON_LONG_RUNNING_CONVERSATION, new Object[0]);
        }
        log.debug((Enum)ConversationMessage.PROMOTED_TRANSIENT, new Object[]{this.id});
        this._transient = false;
        this.id = this.getConversationContext().generateConversationId();
    }

    public void begin(String id) {
        this.verifyConversationContextActive();
        if (!this._transient) {
            throw new IllegalStateException(ConversationMessage.BEGIN_CALLED_ON_LONG_RUNNING_CONVERSATION, new Object[0]);
        }
        if (this.getConversationContext().getConversation(id) != null) {
            throw new IllegalStateException(ConversationMessage.CONVERSATION_ID_ALREADY_IN_USE, id);
        }
        log.debug((Enum)ConversationMessage.PROMOTED_TRANSIENT, new Object[]{id});
        this._transient = false;
        this.id = id;
    }

    public void end() {
        this.verifyConversationContextActive();
        if (this._transient) {
            throw new IllegalStateException(ConversationMessage.END_CALLED_ON_TRANSIENT_CONVERSATION, new Object[0]);
        }
        log.debug((Enum)ConversationMessage.DEMOTED_LRC, new Object[]{this.id});
        this._transient = true;
        this.id = null;
    }

    public String getId() {
        this.verifyConversationContextActive();
        return this.id;
    }

    public long getTimeout() {
        this.verifyConversationContextActive();
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.verifyConversationContextActive();
        this.timeout = timeout;
    }

    public String toString() {
        return "Conversation with id: " + this.id;
    }

    public boolean isTransient() {
        this.verifyConversationContextActive();
        return this._transient;
    }

    public long getLastUsed() {
        this.verifyConversationContextActive();
        return this.lastUsed;
    }

    public void touch() {
        this.verifyConversationContextActive();
        this.lastUsed = System.currentTimeMillis();
    }

    public boolean lock(long timeout) {
        boolean success;
        this.verifyConversationContextActive();
        try {
            success = this.concurrencyLock.tryLock(timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            success = false;
        }
        if (success) {
            log.trace((Enum)ConversationMessage.CONVERSATION_LOCKED, new Object[]{this});
        } else {
            log.warn((Enum)ConversationMessage.CONVERSATION_UNAVAILBLE, new Object[]{timeout, this});
        }
        return success;
    }

    public boolean unlock() {
        this.verifyConversationContextActive();
        if (!this.concurrencyLock.isLocked()) {
            return true;
        }
        if (this.concurrencyLock.isHeldByCurrentThread()) {
            this.concurrencyLock.unlock();
            log.trace((Enum)ConversationMessage.CONVERSATION_UNLOCKED, new Object[]{this});
        } else {
            log.warn((Enum)ConversationMessage.ILLEGAL_CONVERSATION_UNLOCK_ATTEMPT, new Object[]{this, "not owner"});
        }
        return !this.concurrencyLock.isLocked();
    }

    private void verifyConversationContextActive() {
        ConversationContext ctx = this.getConversationContext();
        if (ctx == null || !ctx.isActive()) {
            throw new ContextNotActiveException("Conversation Context not active when method called on conversation " + this);
        }
    }
}

