/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.integration.deployer.env.bda;

import com.google.common.collect.ForwardingCollection;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Map;
import java.util.WeakHashMap;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.weld.integration.deployer.env.WeldDiscoveryEnvironment;
import org.jboss.weld.integration.deployer.env.bda.ArchiveToClasspath;
import org.jboss.weld.integration.deployer.env.bda.Classpath;
import org.jboss.weld.integration.deployer.env.bda.ClasspathFactory;
import org.jboss.weld.integration.util.EjbDiscoveryUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArchiveInfo {
    private static final ClasspathFactory classpathFactory = ClasspathFactory.getInstance();
    private static final Map<ClassLoader, WeakReference<ArchiveInfo>> instances = new WeakHashMap<ClassLoader, WeakReference<ArchiveInfo>>();
    private Collection<String> ejbNames;
    private ArchiveToClasspath classpathAdapter;
    private Classpath classpath;
    private ClassLoader classLoader;
    private final WeldDiscoveryEnvironment environment;

    public static final ArchiveInfo getInstance(ClassLoader classLoader) {
        WeakReference<ArchiveInfo> reference = instances.get(classLoader);
        if (reference == null) {
            return null;
        }
        return (ArchiveInfo)reference.get();
    }

    public ArchiveInfo(final DeploymentUnit unit) {
        this(unit.getClassLoader(), (Collection<String>)new ForwardingCollection<String>(){
            private Collection<String> ejbs;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected Collection<String> delegate() {
                if (this.ejbs == null) {
                    1 var1_1 = this;
                    synchronized (var1_1) {
                        if (this.ejbs == null) {
                            this.ejbs = EjbDiscoveryUtils.getVisibleEJbNames((DeploymentUnit)unit);
                        }
                    }
                }
                return this.ejbs;
            }
        });
    }

    public ArchiveInfo(ClassLoader classLoader, Collection<String> ejbNames) {
        instances.put(classLoader, new WeakReference<ArchiveInfo>(this));
        this.classLoader = classLoader;
        this.classpath = classpathFactory.create(classLoader);
        this.environment = new WeldDiscoveryEnvironment();
        this.ejbNames = ejbNames;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public Classpath getClasspath() {
        return this.classpath;
    }

    public WeldDiscoveryEnvironment getEnvironment() {
        return this.environment;
    }

    public Collection<String> getEjbNames() {
        return this.ejbNames;
    }

    ArchiveToClasspath getClasspathAdapter() {
        if (this.classpathAdapter == null) {
            this.classpathAdapter = new ArchiveToClasspath();
        }
        return this.classpathAdapter;
    }

    boolean hasClasspathAdapter() {
        return this.classpathAdapter != null;
    }

    void cleanUp() {
        instances.remove(this.classLoader);
    }

    public String toString() {
        return "ArchiveInfo[" + this.classLoader + "]";
    }
}

