/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.integration.deployer.metadata;

import java.util.Collection;
import javassist.util.proxy.MethodHandler;
import javassist.util.proxy.ProxyObject;
import org.jboss.classloader.plugins.ClassLoaderUtils;
import org.jboss.classloader.plugins.filter.CombiningClassFilter;
import org.jboss.classloader.spi.filter.ClassFilter;
import org.jboss.classloading.spi.metadata.ClassLoadingMetaData;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.vfs.VirtualFile;
import org.jboss.weld.integration.deployer.metadata.WeldAwareMetadataDeployer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExcludeAppJavassistDeployer
extends WeldAwareMetadataDeployer<ClassLoadingMetaData> {
    private String PO = ClassLoaderUtils.classNameToPath(ProxyObject.class);
    private String MH = ClassLoaderUtils.classNameToPath(MethodHandler.class);
    private ClassFilter excludeFilter;

    public ExcludeAppJavassistDeployer() {
        super(ClassLoadingMetaData.class, true);
        this.setStage(DeploymentStages.PRE_DESCRIBE);
        this.excludeFilter = new ClassFilter(){

            public boolean matchesClassName(String className) {
                return ProxyObject.class.getName().equals(className) || MethodHandler.class.getName().equals(className);
            }

            public boolean matchesResourcePath(String resourcePath) {
                return ExcludeAppJavassistDeployer.this.PO.equals(resourcePath) || ExcludeAppJavassistDeployer.this.MH.equals(resourcePath);
            }

            public boolean matchesPackageName(String packageName) {
                return false;
            }
        };
    }

    @Override
    protected void internalDeploy(VFSDeploymentUnit unit, ClassLoadingMetaData deployment, Collection<VirtualFile> wbXml) throws DeploymentException {
        String excludedPackages = deployment.getExcludedPackages();
        if (excludedPackages != null) {
            return;
        }
        ClassFilter excluded = deployment.getExcluded();
        if (excluded == null) {
            deployment.setExcluded(this.excludeFilter);
        } else {
            deployment.setExcluded((ClassFilter)new CombiningClassFilter(false, new ClassFilter[]{excluded, this.excludeFilter}));
        }
    }
}

