/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.integration.deployer.scanning;

import java.util.Collection;
import org.jboss.classloading.spi.dependency.Module;
import org.jboss.classloading.spi.visitor.ResourceContext;
import org.jboss.classloading.spi.visitor.ResourceFilter;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.scanning.plugins.DeploymentScanningPluginFactory;
import org.jboss.scanning.plugins.helpers.DelegateResourceFilter;
import org.jboss.scanning.plugins.helpers.VoidScanningHandle;
import org.jboss.scanning.spi.ScanningPlugin;
import org.jboss.vfs.VirtualFile;
import org.jboss.weld.integration.deployer.DeployersUtils;
import org.jboss.weld.integration.deployer.env.WeldDiscoveryEnvironment;
import org.jboss.weld.integration.deployer.env.bda.ArchiveInfo;
import org.jboss.weld.integration.deployer.scanning.WeldScanningPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeldScanningPluginFactory
implements DeploymentScanningPluginFactory<VoidScanningHandle, Object> {
    private ResourceFilter weldDeployerFilter = new WeldDeployerFilter();

    protected WeldDiscoveryEnvironment getEnv(DeploymentUnit unit) {
        DeploymentUnit moduleUnit;
        Module module = (Module)moduleUnit.getAttachment(Module.class);
        for (moduleUnit = unit; moduleUnit != null && module == null; moduleUnit = moduleUnit.getParent()) {
            module = (Module)moduleUnit.getAttachment(Module.class);
        }
        if (module == null) {
            throw new IllegalStateException("No module in deployment unit's hierarchy: " + unit.getName());
        }
        ArchiveInfo archive = (ArchiveInfo)moduleUnit.getAttachment(ArchiveInfo.class);
        if (archive == null) {
            throw new IllegalStateException("Archive attachment expected for unit " + unit);
        }
        return archive.getEnvironment();
    }

    public boolean isRelevant(DeploymentUnit unit) {
        Collection cpFiles;
        boolean hasCP;
        Collection wbFiles;
        boolean hasWB;
        if (!DeployersUtils.checkForWeldFilesAcrossDeployment(unit)) {
            return false;
        }
        if (unit.isAttachmentPresent(Module.class)) {
            unit.addAttachment(ArchiveInfo.class, (Object)new ArchiveInfo(unit));
        }
        boolean bl = hasWB = (wbFiles = (Collection)unit.getAttachment("WELD_FILES", Collection.class)) != null && !wbFiles.isEmpty();
        if (hasWB) {
            WeldDiscoveryEnvironment environment = this.getEnv(unit);
            try {
                for (VirtualFile file : wbFiles) {
                    environment.addWeldXmlURL(file.toURL());
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        boolean bl2 = hasCP = (cpFiles = (Collection)unit.getAttachment("WELD_CLASSPATH", Collection.class)) != null && !cpFiles.isEmpty();
        if (hasCP) {
            this.handleRelevantDeployment(unit);
        }
        return hasCP;
    }

    protected void handleRelevantDeployment(DeploymentUnit unit) {
        String name = ResourceFilter.class.getName() + ".recurse";
        ResourceFilter filter = (ResourceFilter)unit.getAttachment(name, ResourceFilter.class);
        if (filter != null) {
            unit.addAttachment(name, (Object)new DelegateResourceFilter(this.weldDeployerFilter, filter));
        } else {
            unit.addAttachment(name, (Object)this.weldDeployerFilter);
        }
    }

    public String getPluginOutput() {
        return ArchiveInfo.class.getName();
    }

    public ScanningPlugin<VoidScanningHandle, Object> create(DeploymentUnit unit) {
        Collection cpFiles = (Collection)unit.getAttachment("WELD_CLASSPATH", Collection.class);
        WeldDiscoveryEnvironment environment = this.getEnv(unit);
        return new WeldScanningPlugin(environment, cpFiles);
    }

    public void setWeldDeployerFilter(ResourceFilter weldDeployerFilter) {
        this.weldDeployerFilter = weldDeployerFilter;
    }

    private static class WeldDeployerFilter
    implements ResourceFilter {
        private WeldDeployerFilter() {
        }

        public boolean accepts(ResourceContext resource) {
            return !resource.getUrl().toString().contains("weld.deployer");
        }
    }
}

