/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.integration.mock;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.beans.metadata.spi.factory.BeanFactory;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.weld.integration.mock.IMockServices;
import org.jboss.weld.integration.vdf.DeploymentUnitAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockServices
implements IMockServices,
Serializable,
BeanFactory,
DeploymentUnitAware,
InvocationHandler {
    private static final long serialVersionUID = 1L;
    private List<Class<?>> interfaces;
    private volatile Object proxy;

    public MockServices(Class<?> ... interfaces) {
        if (interfaces == null || interfaces.length == 0) {
            throw new IllegalArgumentException("Null or empty interfaces");
        }
        this.interfaces = new ArrayList();
        this.interfaces.addAll(Arrays.asList(interfaces));
        this.interfaces.add(IMockServices.class);
        this.interfaces.add(Serializable.class);
        this.interfaces.add(DeploymentUnitAware.class);
    }

    public Object createBean() {
        if (this.proxy == null) {
            this.proxy = Proxy.newProxyInstance(MockServices.class.getClassLoader(), this.interfaces.toArray(new Class[this.interfaces.size()]), (InvocationHandler)this);
        }
        return this.proxy;
    }

    @Override
    public void setDeploymentUnit(DeploymentUnit unit) {
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Class<?> declaringClass = method.getDeclaringClass();
        if (declaringClass.equals(Object.class) || declaringClass.equals(IMockServices.class)) {
            return method.invoke((Object)this, args);
        }
        if (Map.class.isAssignableFrom(method.getReturnType())) {
            return Collections.emptyMap();
        }
        if (Set.class.isAssignableFrom(method.getReturnType())) {
            return Collections.emptySet();
        }
        if (Collection.class.isAssignableFrom(method.getReturnType())) {
            return Collections.emptyList();
        }
        return null;
    }

    public String toString() {
        return "Weld-Mock-Services::" + this.proxy;
    }

    @Override
    public Collection getEjbs() {
        return Collections.emptyList();
    }

    @Override
    public Collection getEjbContainerNames() {
        return Collections.emptyList();
    }
}

