/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jpa.deployment;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.naming.InitialContext;
import javax.persistence.EntityManagerFactory;
import javax.persistence.spi.PersistenceProvider;
import javax.persistence.spi.PersistenceUnitInfo;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.jpa.deployment.ManagedEntityManagerFactory;
import org.jboss.jpa.deployment.PersistenceDeployment;
import org.jboss.jpa.deployment.PersistenceUnitInfoImpl;
import org.jboss.jpa.spi.PersistenceUnit;
import org.jboss.jpa.spi.PersistenceUnitRegistry;
import org.jboss.logging.Logger;
import org.jboss.metadata.jpa.spec.PersistenceUnitMetaData;
import org.jboss.virtual.VFSUtils;
import org.jboss.virtual.VirtualFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistenceUnitDeployment
implements PersistenceUnit {
    private static final Logger log = Logger.getLogger(PersistenceUnitDeployment.class);
    protected InitialContext initialContext;
    protected VFSDeploymentUnit di;
    protected List<String> explicitEntityClasses = new ArrayList<String>();
    protected ManagedEntityManagerFactory managedFactory;
    protected EntityManagerFactory actualFactory;
    protected PersistenceUnitMetaData metaData;
    protected String kernelName;
    protected PersistenceDeployment deployment;
    private Properties defaultPersistenceProperties;

    public PersistenceUnitDeployment(InitialContext initialContext, PersistenceDeployment deployment, List<String> explicitEntityClasses, PersistenceUnitMetaData metadata, String kernelName, VFSDeploymentUnit deploymentUnit, Properties defaultPersistenceProperties) {
        this.deployment = deployment;
        this.initialContext = initialContext;
        this.di = deploymentUnit;
        this.explicitEntityClasses = explicitEntityClasses;
        this.metaData = metadata;
        this.defaultPersistenceProperties = defaultPersistenceProperties;
        this.kernelName = kernelName;
    }

    public void create() {
        PersistenceUnitRegistry.register(this);
    }

    public void destroy() {
        PersistenceUnitRegistry.unregister(this);
    }

    public static String getDefaultKernelName(String unitName) {
        int hashIndex = unitName.indexOf(35);
        if (hashIndex != -1) {
            String relativePath = unitName.substring(3, hashIndex);
            String name = unitName.substring(hashIndex + 1);
            return "persistence.units:jar=" + relativePath + "," + "unitName=" + name;
        }
        return "persistence.units:unitName=" + unitName;
    }

    public PersistenceDeployment getDeployment() {
        return this.deployment;
    }

    protected String getJaccContextId() {
        return this.di.getSimpleName();
    }

    public EntityManagerFactory getActualFactory() {
        return this.actualFactory;
    }

    public PersistenceUnitMetaData getXml() {
        return this.metaData;
    }

    public String getKernelName() {
        return this.kernelName;
    }

    @Override
    public String getName() {
        return this.getKernelName();
    }

    protected VirtualFile getPersistenceUnitRoot() {
        try {
            VirtualFile metaData = this.di.getMetaDataFile("persistence.xml");
            assert (metaData != null) : "Can't find persistence.xml in " + this.di;
            return metaData.getParent().getParent();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public EntityManagerFactory getContainerEntityManagerFactory() {
        return this.getManagedFactory().getEntityManagerFactory();
    }

    public String getEntityManagerName() {
        return this.metaData.getName();
    }

    public ManagedEntityManagerFactory getManagedFactory() {
        if (this.managedFactory == null) {
            log.warn((Object)("managed factory is null, persistence unit " + this.kernelName + " has not yet been started"));
        }
        return this.managedFactory;
    }

    protected Map<String, String> getProperties() {
        Map<String, String> properties = this.metaData.getProperties();
        return properties != null ? properties : Collections.emptyMap();
    }

    private URL getRelativeURL(String jar) {
        try {
            return new URL(jar);
        }
        catch (MalformedURLException e) {
            try {
                URL url = this.di.getFile("").toURL();
                return new URL(url, jar);
            }
            catch (Exception e1) {
                throw new RuntimeException("could not find relative path: " + jar, e1);
            }
        }
    }

    public void start() throws Exception {
        String urlString;
        log.info((Object)("Starting persistence unit " + this.kernelName));
        Properties props = new Properties();
        props.putAll((Map<?, ?>)this.defaultPersistenceProperties);
        props.put("hibernate.jacc.ctx.id", this.getJaccContextId());
        ArrayList<URL> jarFiles = new ArrayList<URL>();
        Set files = this.metaData.getJarFiles();
        if (files != null) {
            for (String jar : files) {
                jarFiles.add(this.getRelativeURL(jar));
            }
        }
        VirtualFile root = this.getPersistenceUnitRoot();
        log.debug((Object)("Persistence root: " + root));
        URL url = root.toURL();
        if (!VFSUtils.isNestedFile((VirtualFile)root) && (urlString = url.toExternalForm()).startsWith("vfs")) {
            url = urlString.startsWith("vfszip") ? new URL("file" + urlString.substring(6)) : new URL(urlString.substring(3));
        }
        PersistenceUnitInfoImpl pi = new PersistenceUnitInfoImpl(this.metaData, props, this.di.getClassLoader(), url, jarFiles, this.initialContext);
        if (this.explicitEntityClasses.size() > 0) {
            List<String> classes = pi.getManagedClassNames();
            if (classes == null) {
                classes = this.explicitEntityClasses;
            } else {
                classes.addAll(this.explicitEntityClasses);
            }
            pi.setManagedClassnames(classes);
        }
        Class<?> providerClass = Thread.currentThread().getContextClassLoader().loadClass(pi.getPersistenceProviderClassName());
        if (!pi.getProperties().containsKey("hibernate.session_factory_name")) {
            pi.getProperties().put("hibernate.session_factory_name", this.kernelName);
        }
        PersistenceProvider pp = (PersistenceProvider)providerClass.newInstance();
        this.actualFactory = pp.createContainerEntityManagerFactory((PersistenceUnitInfo)pi, null);
        this.managedFactory = new ManagedEntityManagerFactory(this.actualFactory, this.kernelName);
    }

    public void stop() throws Exception {
        log.info((Object)("Stopping persistence unit " + this.kernelName));
        this.managedFactory.destroy();
    }
}

