/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jpa.resolvers.strategy;

import java.util.Collection;
import org.jboss.beans.metadata.api.annotations.Inject;
import org.jboss.deployers.client.spi.Deployment;
import org.jboss.deployers.client.spi.main.MainDeployer;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.structure.spi.main.MainDeployerStructure;
import org.jboss.jpa.resolvers.PersistenceUnitDependencyResolver;
import org.jboss.jpa.resolvers.strategy.BaseSearchStrategy;

public class JBossSearchStrategy
extends BaseSearchStrategy {
    private MainDeployer mainDeployer;
    private MainDeployerStructure mainDeployerStructure;

    public String findPersistenceUnitSupplier(PersistenceUnitDependencyResolver resolver, DeploymentUnit deploymentUnit, String persistenceUnitName) {
        String name = super.findPersistenceUnitSupplier(resolver, deploymentUnit, persistenceUnitName);
        if (name != null) {
            return name;
        }
        return this.findWithinMainDeployer(resolver, persistenceUnitName);
    }

    protected String findWithinMainDeployer(PersistenceUnitDependencyResolver resolver, String persistenceUnitName) {
        Collection topLevelDeployments = this.mainDeployer.getTopLevel();
        if (topLevelDeployments == null) {
            return null;
        }
        for (Deployment deployment : topLevelDeployments) {
            String beanName;
            String name = deployment.getName();
            DeploymentUnit deploymentUnit = this.mainDeployerStructure.getDeploymentUnit(name);
            if (deploymentUnit == null || (beanName = this.findWithinApplication(resolver, deploymentUnit, persistenceUnitName)) == null) continue;
            return beanName;
        }
        return null;
    }

    @Inject
    public void setMainDeployer(MainDeployer mainDeployer) {
        this.mainDeployer = mainDeployer;
    }

    @Inject
    public void setMainDeployerStructure(MainDeployerStructure mainDeployerStructure) {
        this.mainDeployerStructure = mainDeployerStructure;
    }
}

