/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jpa.deployment;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.spi.PersistenceUnitInfo;
import org.jboss.beans.metadata.api.annotations.Inject;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.jpa.builder.CEMFBuilder;
import org.jboss.jpa.deployment.ManagedEntityManagerFactory;
import org.jboss.jpa.deployment.PersistenceDeployment;
import org.jboss.jpa.impl.deployment.PersistenceUnitInfoImpl;
import org.jboss.jpa.injection.InjectedEntityManagerFactory;
import org.jboss.jpa.spi.PersistenceUnit;
import org.jboss.jpa.spi.PersistenceUnitRegistry;
import org.jboss.jpa.spi.XPCResolver;
import org.jboss.jpa.tx.TransactionScopedEntityManager;
import org.jboss.logging.Logger;
import org.jboss.metadata.jpa.spec.PersistenceUnitMetaData;
import org.jboss.util.naming.NonSerializableFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PersistenceUnitDeployment
implements PersistenceUnit {
    private static final Logger log = Logger.getLogger(PersistenceUnitDeployment.class);
    protected InitialContext initialContext;
    protected VFSDeploymentUnit di;
    protected List<String> explicitEntityClasses = new ArrayList<String>();
    protected ManagedEntityManagerFactory managedFactory;
    protected EntityManagerFactory actualFactory;
    protected PersistenceUnitMetaData metaData;
    protected String kernelName;
    protected PersistenceDeployment deployment;
    private Properties defaultPersistenceProperties;
    private CEMFBuilder cemfBuilder;
    private XPCResolver xpcResolver;

    public PersistenceUnitDeployment(InitialContext initialContext, PersistenceDeployment deployment, List<String> explicitEntityClasses, PersistenceUnitMetaData metadata, String kernelName, VFSDeploymentUnit deploymentUnit, Properties defaultPersistenceProperties) {
        this.deployment = deployment;
        this.initialContext = initialContext;
        this.di = deploymentUnit;
        this.explicitEntityClasses = explicitEntityClasses;
        this.metaData = metadata;
        this.defaultPersistenceProperties = defaultPersistenceProperties;
        this.kernelName = kernelName;
    }

    public void create() {
        assert (this.xpcResolver != null) : "xpcResolver wasn't set on " + this;
        PersistenceUnitRegistry.register((PersistenceUnit)this);
    }

    public void destroy() {
        PersistenceUnitRegistry.unregister((PersistenceUnit)this);
    }

    public static String getDefaultKernelName(String unitName) {
        int hashIndex = unitName.indexOf(35);
        if (hashIndex != -1) {
            String relativePath = unitName.substring(3, hashIndex);
            String name = unitName.substring(hashIndex + 1);
            return "persistence.units:jar=" + relativePath + "," + "unitName=" + name;
        }
        return "persistence.units:unitName=" + unitName;
    }

    public PersistenceDeployment getDeployment() {
        return this.deployment;
    }

    protected String getJaccContextId() {
        return this.di.getSimpleName();
    }

    public EntityManagerFactory getActualFactory() {
        return this.actualFactory;
    }

    public PersistenceUnitMetaData getXml() {
        return this.metaData;
    }

    public String getKernelName() {
        return this.kernelName;
    }

    public String getName() {
        return this.getKernelName();
    }

    protected abstract URL getPersistenceUnitURL();

    public EntityManagerFactory getContainerEntityManagerFactory() {
        return this.actualFactory;
    }

    public String getEntityManagerName() {
        return this.metaData.getName();
    }

    public ManagedEntityManagerFactory getManagedFactory() {
        if (this.managedFactory == null) {
            log.warn((Object)("managed factory is null, persistence unit " + this.kernelName + " has not yet been started"));
        }
        return this.managedFactory;
    }

    protected Map<String, String> getProperties() {
        Map<String, String> properties = this.metaData.getProperties();
        return properties != null ? properties : Collections.emptyMap();
    }

    protected abstract URL getRelativeURL(String var1);

    public EntityManager getTransactionScopedEntityManager() {
        return this.managedFactory.getTransactionScopedEntityManager();
    }

    public XPCResolver getXPCResolver() {
        assert (this.xpcResolver != null) : "xpcResolver is null in " + this;
        return this.xpcResolver;
    }

    public boolean isInTx() {
        return this.managedFactory.isInTx();
    }

    @Inject
    public void setCEMFBuilder(CEMFBuilder builder) {
        this.cemfBuilder = builder;
    }

    @Inject
    public void setXPCResolver(XPCResolver xpcResolver) {
        this.xpcResolver = xpcResolver;
    }

    public void start() throws Exception {
        String entityManagerFactoryJndiName;
        log.info((Object)("Starting persistence unit " + this.kernelName));
        Properties props = new Properties();
        props.putAll((Map<?, ?>)this.defaultPersistenceProperties);
        props.put("hibernate.jacc.ctx.id", this.getJaccContextId());
        ArrayList<URL> jarFiles = new ArrayList<URL>();
        Set files = this.metaData.getJarFiles();
        if (files != null) {
            for (String jar : files) {
                jarFiles.add(this.getRelativeURL(jar));
            }
        }
        URL url = this.getPersistenceUnitURL();
        log.debug((Object)("Persistence url: " + url));
        PersistenceUnitInfoImpl pi = new PersistenceUnitInfoImpl(this.metaData, props, this.di.getClassLoader(), url, jarFiles, (Context)this.initialContext);
        if (this.explicitEntityClasses.size() > 0) {
            List<String> classes = pi.getManagedClassNames();
            if (classes == null) {
                classes = this.explicitEntityClasses;
            } else {
                classes.addAll(this.explicitEntityClasses);
            }
            pi.setManagedClassnames(classes);
        }
        if (!pi.getProperties().containsKey("hibernate.session_factory_name")) {
            pi.getProperties().put("hibernate.session_factory_name", this.kernelName);
        }
        if (pi.getProperties().getProperty("hibernate.cache.region_prefix") == null) {
            pi.getProperties().setProperty("hibernate.cache.region_prefix", this.kernelName);
        }
        this.actualFactory = this.cemfBuilder.build((DeploymentUnit)this.di, (PersistenceUnitInfo)pi);
        this.managedFactory = new ManagedEntityManagerFactory(this);
        String entityManagerJndiName = (String)props.get("jboss.entity.manager.jndi.name");
        if (entityManagerJndiName != null) {
            TransactionScopedEntityManager injectedManager = new TransactionScopedEntityManager(this.managedFactory);
            NonSerializableFactory.rebind((Context)this.initialContext, (String)entityManagerJndiName, (Object)((Object)injectedManager), (boolean)true);
        }
        if ((entityManagerFactoryJndiName = (String)props.get("jboss.entity.manager.factory.jndi.name")) != null) {
            InjectedEntityManagerFactory injectedFactory = new InjectedEntityManagerFactory(this.managedFactory);
            NonSerializableFactory.rebind((Context)this.initialContext, (String)entityManagerFactoryJndiName, (Object)((Object)injectedFactory), (boolean)true);
        }
    }

    public void stop() throws Exception {
        String entityManagerFactoryJndiName;
        log.info((Object)("Stopping persistence unit " + this.kernelName));
        String entityManagerJndiName = this.getProperties().get("jboss.entity.manager.jndi.name");
        if (entityManagerJndiName != null) {
            this.unbind(entityManagerJndiName);
        }
        if ((entityManagerFactoryJndiName = this.getProperties().get("jboss.entity.manager.factory.jndi.name")) != null) {
            this.unbind(entityManagerFactoryJndiName);
        }
        this.actualFactory.close();
    }

    private void unbind(String name) throws NamingException {
        NonSerializableFactory.unbind((String)name);
        this.initialContext.unbind(name);
    }

    public void verifyInTx() {
        this.managedFactory.verifyInTx();
    }
}

