/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jpa.deployment.vfs3;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Properties;
import javax.naming.InitialContext;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.jpa.deployment.PersistenceDeployment;
import org.jboss.jpa.deployment.PersistenceUnitDeployment;
import org.jboss.metadata.jpa.spec.PersistenceUnitMetaData;
import org.jboss.vfs.VirtualFile;
import org.jboss.vfs.VirtualFileVisitor;
import org.jboss.vfs.VisitorAttributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistenceUnitDeploymentImpl
extends PersistenceUnitDeployment {
    public PersistenceUnitDeploymentImpl(InitialContext initialContext, PersistenceDeployment deployment, List<String> explicitEntityClasses, PersistenceUnitMetaData metadata, String kernelName, VFSDeploymentUnit deploymentUnit, Properties defaultPersistenceProperties) {
        super(initialContext, deployment, explicitEntityClasses, metadata, kernelName, deploymentUnit, defaultPersistenceProperties);
    }

    protected URL getPersistenceUnitURL() {
        try {
            VirtualFile metaData = this.di.getMetaDataFile("persistence.xml");
            assert (metaData != null) : "Can't find persistence.xml in " + this.di;
            return this.getJarFileUrl(metaData.getParent().getParent());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected URL getRelativeURL(String jar) {
        try {
            return new URL(jar);
        }
        catch (MalformedURLException e) {
            try {
                VirtualFile deploymentUnitFile = this.di.getFile("");
                VirtualFile parent = deploymentUnitFile.getParent();
                VirtualFile baseDir = parent != null ? parent : deploymentUnitFile;
                VirtualFile jarFile = baseDir.getChild(jar);
                if (jarFile == null) {
                    throw new RuntimeException("could not find child '" + jar + "' on '" + baseDir + "'");
                }
                return this.getJarFileUrl(jarFile);
            }
            catch (Exception e1) {
                throw new RuntimeException("could not find relative path: " + jar, e1);
            }
        }
    }

    private URL getJarFileUrl(VirtualFile virtualFile) throws MalformedURLException, IOException {
        if (virtualFile.isDirectory()) {
            VirtualFileVisitor visitor = new VirtualFileVisitor(){

                public void visit(VirtualFile virtualFile) {
                    try {
                        virtualFile.getPhysicalFile();
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Failed to force explosion of VirtualFile: " + virtualFile, e);
                    }
                }

                public VisitorAttributes getAttributes() {
                    return VisitorAttributes.RECURSE_LEAVES_ONLY;
                }
            };
            virtualFile.visit(visitor);
            return virtualFile.getPhysicalFile().toURI().toURL();
        }
        return virtualFile.toURL();
    }
}

