/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.example.booking;

import java.util.Calendar;
import javax.ejb.Remove;
import javax.ejb.Stateful;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceContextType;
import org.jboss.seam.annotations.Begin;
import org.jboss.seam.annotations.End;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Out;
import org.jboss.seam.annotations.security.Restrict;
import org.jboss.seam.core.Events;
import org.jboss.seam.example.booking.Booking;
import org.jboss.seam.example.booking.Hotel;
import org.jboss.seam.example.booking.HotelBooking;
import org.jboss.seam.example.booking.User;
import org.jboss.seam.faces.FacesMessages;
import org.jboss.seam.log.Log;

@Stateful
@Name(value="hotelBooking")
@Restrict(value="#{identity.loggedIn}")
public class HotelBookingAction
implements HotelBooking {
    @PersistenceContext(type=PersistenceContextType.EXTENDED)
    private EntityManager em;
    @In
    private User user;
    @In(required=false)
    @Out
    private Hotel hotel;
    @In(required=false)
    @Out(required=false)
    private Booking booking;
    @In
    private FacesMessages facesMessages;
    @In
    private Events events;
    @Logger
    private Log log;
    private boolean bookingValid;
    private String hotelName;

    @Begin
    public void selectHotel(Hotel selectedHotel) {
        this.hotel = (Hotel)this.em.merge((Object)selectedHotel);
        this.hotelName = this.hotel.getName();
    }

    public String getSelectedHotelName() {
        return this.hotelName;
    }

    public void bookHotel() {
        this.booking = new Booking(this.hotel, this.user);
        Calendar calendar = Calendar.getInstance();
        this.booking.setCheckinDate(calendar.getTime());
        calendar.add(5, 1);
        this.booking.setCheckoutDate(calendar.getTime());
    }

    public void setBookingDetails() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -1);
        if (this.booking.getCheckinDate().before(calendar.getTime())) {
            this.facesMessages.addToControl("checkinDate", "Check in date must be a future date", new Object[0]);
            this.bookingValid = false;
        } else if (!this.booking.getCheckinDate().before(this.booking.getCheckoutDate())) {
            this.facesMessages.addToControl("checkoutDate", "Check out date must be later than check in date", new Object[0]);
            this.bookingValid = false;
        } else {
            this.bookingValid = true;
        }
    }

    public boolean isBookingValid() {
        return this.bookingValid;
    }

    @End
    public void confirm() {
        this.em.persist((Object)this.booking);
        this.facesMessages.add("Thank you, #{user.name}, your confimation number for #{hotel.name} is #{booking.id}", new Object[0]);
        this.log.info((Object)"New booking: #{booking.id} for #{user.username}", new Object[0]);
        this.events.raiseTransactionSuccessEvent("bookingConfirmed", new Object[0]);
    }

    @End
    public void cancel() {
    }

    @Remove
    public void destroy() {
    }
}

