/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.example.booking;

import java.io.Serializable;
import java.util.List;
import javax.ejb.Remove;
import javax.ejb.Stateful;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.datamodel.DataModel;
import org.jboss.seam.annotations.datamodel.DataModelSelection;
import org.jboss.seam.annotations.security.Restrict;
import org.jboss.seam.example.booking.Booking;
import org.jboss.seam.example.booking.BookingList;
import org.jboss.seam.example.booking.User;
import org.jboss.seam.faces.FacesMessages;
import org.jboss.seam.log.Log;

@Stateful
@Scope(value=ScopeType.SESSION)
@Name(value="bookingList")
@Restrict(value="#{identity.loggedIn}")
@TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
public class BookingListAction
implements BookingList,
Serializable {
    private static final long serialVersionUID = 1L;
    @PersistenceContext
    private EntityManager em;
    @In
    private User user;
    @DataModel
    private List<Booking> bookings;
    @DataModelSelection
    private Booking booking;
    @Logger
    private Log log;

    @Factory
    @Observer(value={"bookingConfirmed"})
    public void getBookings() {
        this.bookings = this.em.createQuery("select b from Booking b where b.user.username = :username order by b.checkinDate").setParameter("username", (Object)this.user.getUsername()).getResultList();
    }

    public void cancel() {
        this.log.info((Object)"Cancel booking: #{bookingList.booking.id} for #{user.username}", new Object[0]);
        Booking cancelled = (Booking)this.em.find(Booking.class, (Object)this.booking.getId());
        if (cancelled != null) {
            this.em.remove((Object)cancelled);
        }
        this.getBookings();
        FacesMessages.instance().add("Booking cancelled for confirmation number #{bookingList.booking.id}", new Object[0]);
    }

    public Booking getBooking() {
        return this.booking;
    }

    @Remove
    public void destroy() {
    }
}

