/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.example.booking;

import javax.ejb.Remove;
import javax.ejb.Stateful;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Out;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.security.Restrict;
import org.jboss.seam.example.booking.ChangePassword;
import org.jboss.seam.example.booking.User;
import org.jboss.seam.faces.FacesMessages;

@Stateful
@Scope(value=ScopeType.EVENT)
@Name(value="changePassword")
@Restrict(value="#{identity.loggedIn}")
public class ChangePasswordAction
implements ChangePassword {
    @In
    @Out
    private User user;
    @PersistenceContext
    private EntityManager em;
    private String verify;
    private boolean changed;
    @In
    private FacesMessages facesMessages;

    public void changePassword() {
        if (this.user.getPassword().equals(this.verify)) {
            this.user = (User)this.em.merge((Object)this.user);
            this.facesMessages.add("Password updated", new Object[0]);
            this.changed = true;
        } else {
            this.facesMessages.addToControl("verify", "Re-enter new password", new Object[0]);
            this.revertUser();
            this.verify = null;
        }
    }

    public boolean isChanged() {
        return this.changed;
    }

    private void revertUser() {
        this.user = (User)this.em.find(User.class, (Object)this.user.getUsername());
    }

    public String getVerify() {
        return this.verify;
    }

    public void setVerify(String verify) {
        this.verify = verify;
    }

    @Remove
    public void destroy() {
    }
}

