/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.example.booking;

import java.util.List;
import javax.ejb.Remove;
import javax.ejb.Stateful;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.datamodel.DataModel;
import org.jboss.seam.annotations.security.Restrict;
import org.jboss.seam.example.booking.Hotel;
import org.jboss.seam.example.booking.HotelSearching;

@Stateful
@Name(value="hotelSearch")
@Scope(value=ScopeType.SESSION)
@Restrict(value="#{identity.loggedIn}")
public class HotelSearchingAction
implements HotelSearching {
    @PersistenceContext
    private EntityManager em;
    private String searchString;
    private int pageSize = 10;
    private int page;
    @DataModel
    private List<Hotel> hotels;

    public void find() {
        this.page = 0;
        this.queryHotels();
    }

    public void nextPage() {
        ++this.page;
        this.queryHotels();
    }

    private void queryHotels() {
        this.hotels = this.em.createQuery("select h from Hotel h where lower(h.name) like #{pattern} or lower(h.city) like #{pattern} or lower(h.zip) like #{pattern} or lower(h.address) like #{pattern}").setMaxResults(this.pageSize).setFirstResult(this.page * this.pageSize).getResultList();
    }

    public boolean isNextPageAvailable() {
        return this.hotels != null && this.hotels.size() == this.pageSize;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    @Factory(value="pattern", scope=ScopeType.EVENT)
    public String getSearchPattern() {
        return this.searchString == null ? "%" : '%' + this.searchString.toLowerCase().replace('*', '%') + '%';
    }

    public String getSearchString() {
        return this.searchString;
    }

    public void setSearchString(String searchString) {
        this.searchString = searchString;
    }

    @Remove
    public void destroy() {
    }
}

