/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.DomNamespaceNode;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.DomNodeList;
import com.gargoylesoftware.htmlunit.html.NamedAttrNodeMapImpl;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringEscapeUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.w3c.dom.TypeInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DomElement
extends DomNamespaceNode
implements Element {
    private static final long serialVersionUID = 8573853996234946066L;
    public static final String ATTRIBUTE_NOT_DEFINED = new String("");
    public static final String ATTRIBUTE_VALUE_EMPTY = new String("");
    private NamedAttrNodeMapImpl attributes_ = NamedAttrNodeMapImpl.EMPTY_MAP;
    private Map<String, String> namespaces_ = new HashMap<String, String>();

    public DomElement(String namespaceURI, String qualifiedName, SgmlPage page, Map<String, DomAttr> attributes) {
        super(namespaceURI, qualifiedName, page);
        if (attributes != null && !attributes.isEmpty()) {
            this.attributes_ = new NamedAttrNodeMapImpl(this, this.isAttributeCaseSensitive(), attributes);
            for (DomAttr entry : this.attributes_.values()) {
                entry.setParentNode(this);
                String attrNamespaceURI = entry.getNamespaceURI();
                if (attrNamespaceURI == null) continue;
                this.namespaces_.put(attrNamespaceURI, entry.getPrefix());
            }
        }
    }

    @Override
    public String getNodeName() {
        if (this.getNamespaceURI() == null) {
            return this.getLocalName();
        }
        return this.getQualifiedName();
    }

    @Override
    public final short getNodeType() {
        return 1;
    }

    protected Map<String, String> namespaces() {
        return this.namespaces_;
    }

    @Override
    public final String getTagName() {
        return this.getNodeName();
    }

    @Override
    public final boolean hasAttributes() {
        return !this.attributes_.isEmpty();
    }

    @Override
    public boolean hasAttribute(String attributeName) {
        return this.attributes_.containsKey(attributeName);
    }

    protected void printOpeningTagContentAsXml(PrintWriter printWriter) {
        printWriter.print(this.getTagName());
        for (String name : this.attributes_.keySet()) {
            printWriter.print(" ");
            printWriter.print(name);
            printWriter.print("=\"");
            printWriter.print(StringEscapeUtils.escapeXml(this.attributes_.get(name).getNodeValue()));
            printWriter.print("\"");
        }
    }

    @Override
    protected void printXml(String indent, PrintWriter printWriter) {
        boolean hasChildren = this.getFirstChild() != null;
        printWriter.print(indent + "<");
        this.printOpeningTagContentAsXml(printWriter);
        if (!hasChildren && !this.isEmptyXmlTagExpanded()) {
            printWriter.println("/>");
        } else {
            printWriter.println(">");
            this.printChildrenAsXml(indent, printWriter);
            printWriter.println(indent + "</" + this.getTagName() + ">");
        }
    }

    protected boolean isEmptyXmlTagExpanded() {
        return false;
    }

    String getQualifiedName(String namespaceURI, String localName) {
        String prefix;
        String qualifiedName = namespaceURI != null ? ((prefix = this.namespaces().get(namespaceURI)) != null ? prefix + ':' + localName : null) : localName;
        return qualifiedName;
    }

    @Override
    public String getAttribute(String attributeName) {
        DomAttr attr = this.attributes_.get(attributeName);
        if (attr != null) {
            return attr.getNodeValue();
        }
        return ATTRIBUTE_NOT_DEFINED;
    }

    @Deprecated
    public final String getAttributeValue(String attributeName) {
        return this.getAttribute(attributeName);
    }

    @Override
    public void removeAttribute(String attributeName) {
        this.attributes_.remove(attributeName.toLowerCase());
    }

    @Override
    public final void removeAttributeNS(String namespaceURI, String localName) {
        String qualifiedName = this.getQualifiedName(namespaceURI, localName);
        if (qualifiedName != null) {
            this.removeAttribute(qualifiedName);
        }
    }

    @Override
    public final Attr removeAttributeNode(Attr attribute) {
        throw new UnsupportedOperationException("DomElement.removeAttributeNode is not yet implemented.");
    }

    @Override
    public final boolean hasAttributeNS(String namespaceURI, String localName) {
        String qualifiedName = this.getQualifiedName(namespaceURI, localName);
        if (qualifiedName != null) {
            return this.attributes_.get(qualifiedName) != null;
        }
        return false;
    }

    public final Map<String, DomAttr> getAttributesMap() {
        return this.attributes_;
    }

    @Override
    public NamedNodeMap getAttributes() {
        return this.attributes_;
    }

    @Override
    public final void setAttribute(String attributeName, String attributeValue) {
        this.setAttributeNS(null, attributeName, attributeValue);
    }

    @Override
    public void setAttributeNS(String namespaceURI, String qualifiedName, String attributeValue) {
        String value = attributeValue;
        if (this.attributes_ == NamedAttrNodeMapImpl.EMPTY_MAP) {
            this.attributes_ = new NamedAttrNodeMapImpl(this, this.isAttributeCaseSensitive());
        }
        DomAttr newAttr = new DomAttr(this.getPage(), namespaceURI, qualifiedName, value);
        newAttr.setParentNode(this);
        this.attributes_.put(qualifiedName, newAttr);
        if (namespaceURI != null) {
            this.namespaces().put(namespaceURI, newAttr.getPrefix());
        }
    }

    protected boolean isAttributeCaseSensitive() {
        return true;
    }

    @Deprecated
    public final void setAttributeValue(String attributeName, String attributeValue) {
        this.setAttributeNS(null, attributeName, attributeValue);
    }

    @Deprecated
    public final void setAttributeValue(String namespaceURI, String qualifiedName, String attributeValue) {
        this.setAttributeNS(namespaceURI, qualifiedName, attributeValue);
    }

    @Override
    public final String getAttributeNS(String namespaceURI, String localName) {
        String qualifiedName = this.getQualifiedName(namespaceURI, localName);
        if (qualifiedName != null) {
            return this.getAttribute(qualifiedName);
        }
        return ATTRIBUTE_NOT_DEFINED;
    }

    @Override
    public Attr getAttributeNode(String name) {
        throw new UnsupportedOperationException("DomElement.getAttributeNode is not yet implemented.");
    }

    @Override
    public Attr getAttributeNodeNS(String namespaceURI, String localName) {
        throw new UnsupportedOperationException("DomElement.getAttributeNodeNS is not yet implemented.");
    }

    @Override
    public NodeList getElementsByTagName(String tagName) {
        return new DomNodeList(this, ".//*[local-name()='" + tagName + "']");
    }

    @Override
    public NodeList getElementsByTagNameNS(String namespace, String localName) {
        throw new UnsupportedOperationException("DomElement.getElementsByTagNameNS is not yet implemented.");
    }

    @Override
    public TypeInfo getSchemaTypeInfo() {
        throw new UnsupportedOperationException("DomElement.getSchemaTypeInfo is not yet implemented.");
    }

    @Override
    public void setIdAttribute(String name, boolean isId) {
        throw new UnsupportedOperationException("DomElement.setIdAttribute is not yet implemented.");
    }

    @Override
    public void setIdAttributeNS(String namespaceURI, String localName, boolean isId) {
        throw new UnsupportedOperationException("DomElement.setIdAttributeNS is not yet implemented.");
    }

    @Override
    public Attr setAttributeNode(Attr attribute) {
        throw new UnsupportedOperationException("DomElement.setAttributeNode is not yet implemented.");
    }

    @Override
    public Attr setAttributeNodeNS(Attr attribute) {
        throw new UnsupportedOperationException("DomElement.setAttributeNodeNS is not yet implemented.");
    }

    @Override
    public final void setIdAttributeNode(Attr idAttr, boolean isId) {
        throw new UnsupportedOperationException("DomElement.setIdAttributeNode is not yet implemented.");
    }

    @Override
    public DomNode cloneNode(boolean deep) {
        DomElement clone = (DomElement)super.cloneNode(deep);
        clone.attributes_ = new NamedAttrNodeMapImpl(clone, this.isAttributeCaseSensitive());
        clone.attributes_.putAll(this.attributes_);
        return clone;
    }
}

