/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.configuration.ClassConfiguration;
import com.gargoylesoftware.htmlunit.javascript.configuration.JavaScriptConfiguration;
import com.gargoylesoftware.htmlunit.javascript.host.ActiveXObjectImpl;
import com.gargoylesoftware.htmlunit.javascript.host.XMLDocument;
import com.gargoylesoftware.htmlunit.javascript.host.XMLHttpRequest;
import com.gargoylesoftware.htmlunit.javascript.host.XSLTemplate;
import java.lang.reflect.Method;
import java.util.Map;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Function;
import net.sourceforge.htmlunit.corejs.javascript.FunctionObject;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActiveXObject
extends SimpleScriptable {
    private static final long serialVersionUID = 7327032075131452226L;
    private static final transient Log mainLog_ = LogFactory.getLog(SimpleScriptable.class);

    public static Scriptable jsConstructor(Context cx, Object[] args, Function ctorObj, boolean inNewExpr) {
        block12: {
            String mapValue;
            if (args.length < 1 || args.length > 2) {
                throw Context.reportRuntimeError("ActiveXObject Error: constructor must have one or two String parameters.");
            }
            if (args[0] == Context.getUndefinedValue()) {
                throw Context.reportRuntimeError("ActiveXObject Error: constructor parameter is undefined.");
            }
            if (!(args[0] instanceof String)) {
                throw Context.reportRuntimeError("ActiveXObject Error: constructor parameter must be a String.");
            }
            String activeXName = (String)args[0];
            if (ActiveXObject.isXMLHttpRequest(activeXName)) {
                return ActiveXObject.buildXMLHttpRequest();
            }
            if (ActiveXObject.isXMLDocument(activeXName)) {
                return ActiveXObject.buildXMLDocument(ActiveXObject.getWindow(ctorObj).getWebWindow());
            }
            if (ActiveXObject.isXMLTemplate(activeXName)) {
                return ActiveXObject.buildXSLTemplate();
            }
            WebClient webClient = ActiveXObject.getWindow(ctorObj).getWebWindow().getWebClient();
            Map<String, String> map = webClient.getActiveXObjectMap();
            if (map != null && (mapValue = map.get(activeXName)) != null) {
                String xClassString = mapValue;
                Object object = null;
                try {
                    Class<?> xClass = Class.forName(xClassString);
                    object = xClass.newInstance();
                }
                catch (Exception e) {
                    throw Context.reportRuntimeError("ActiveXObject Error: failed instantiating class " + xClassString + " because " + e.getMessage() + ".");
                }
                return Context.toObject(object, ctorObj);
            }
            if (webClient.isActiveXNative() && System.getProperty("os.name").contains("Windows")) {
                try {
                    return new ActiveXObjectImpl(activeXName);
                }
                catch (Exception e) {
                    if (!mainLog_.isWarnEnabled()) break block12;
                    mainLog_.warn("Error initiating Jacob", e);
                }
            }
        }
        throw Context.throwAsScriptRuntimeEx(new Exception("Automation server can't create object"));
    }

    static boolean isXMLHttpRequest(String name) {
        if (name == null) {
            return false;
        }
        return "Microsoft.XMLHTTP".equalsIgnoreCase(name = name.toLowerCase()) || name.startsWith("Msxml2.XMLHTTP".toLowerCase());
    }

    static boolean isXMLDocument(String name) {
        if (name == null) {
            return false;
        }
        return "Microsoft.XMLDOM".equalsIgnoreCase(name = name.toLowerCase()) || name.matches("msxml\\d*\\.domdocument.*") || name.matches("msxml\\d*\\.freethreadeddomdocument.*");
    }

    static boolean isXMLTemplate(String name) {
        if (name == null) {
            return false;
        }
        name = name.toLowerCase();
        return name.matches("msxml\\d*\\.xsltemplate.*");
    }

    private static Scriptable buildXMLHttpRequest() {
        XMLHttpRequest scriptable = new XMLHttpRequest(false);
        ActiveXObject.addProperty((SimpleScriptable)scriptable, "onreadystatechange", true, true);
        ActiveXObject.addProperty((SimpleScriptable)scriptable, "readyState", true, false);
        ActiveXObject.addProperty((SimpleScriptable)scriptable, "responseText", true, false);
        ActiveXObject.addProperty((SimpleScriptable)scriptable, "responseXML", true, false);
        ActiveXObject.addProperty((SimpleScriptable)scriptable, "status", true, false);
        ActiveXObject.addProperty((SimpleScriptable)scriptable, "statusText", true, false);
        ActiveXObject.addFunction(scriptable, "abort");
        ActiveXObject.addFunction(scriptable, "getAllResponseHeaders");
        ActiveXObject.addFunction(scriptable, "getResponseHeader");
        ActiveXObject.addFunction(scriptable, "open");
        ActiveXObject.addFunction(scriptable, "send");
        ActiveXObject.addFunction(scriptable, "setRequestHeader");
        return scriptable;
    }

    private static Scriptable buildXSLTemplate() {
        XSLTemplate scriptable = new XSLTemplate();
        ActiveXObject.addProperty((SimpleScriptable)scriptable, "stylesheet", true, true);
        ActiveXObject.addFunction(scriptable, "createProcessor");
        return scriptable;
    }

    static XMLDocument buildXMLDocument(WebWindow enclosingWindow) {
        XMLDocument document = new XMLDocument(enclosingWindow);
        ActiveXObject.addProperty((SimpleScriptable)document, "async", true, true);
        ActiveXObject.addProperty((SimpleScriptable)document, "parseError", true, false);
        ActiveXObject.addProperty((SimpleScriptable)document, "preserveWhiteSpace", true, true);
        ActiveXObject.addProperty((SimpleScriptable)document, "xml", true, false);
        ActiveXObject.addFunction(document, "getElementsByTagName");
        ActiveXObject.addFunction(document, "load");
        ActiveXObject.addFunction(document, "loadXML");
        ActiveXObject.addFunction(document, "selectNodes");
        ActiveXObject.addFunction(document, "selectSingleNode");
        ActiveXObject.addFunction(document, "setProperty");
        JavaScriptConfiguration jsConfig = JavaScriptConfiguration.getInstance(BrowserVersion.INTERNET_EXPLORER_7);
        String className = "Document";
        while (className.trim().length() != 0) {
            ClassConfiguration classConfig = jsConfig.getClassConfiguration(className);
            for (String function : classConfig.functionKeys()) {
                ActiveXObject.addFunction(document, function);
            }
            for (String property : classConfig.propertyKeys()) {
                ActiveXObject.addProperty((SimpleScriptable)document, property, classConfig.getPropertyReadMethod(property) != null, classConfig.getPropertyWriteMethod(property) != null);
            }
            className = classConfig.getExtendedClass();
        }
        return document;
    }

    private static void addFunction(SimpleScriptable scriptable, String jsMethodName) {
        ActiveXObject.addFunction(scriptable, jsMethodName, "jsxFunction_" + jsMethodName);
    }

    private static void addFunction(SimpleScriptable scriptable, String jsMethodName, String javaMethodName) {
        Method javaFunction = ActiveXObject.getMethod(scriptable.getClass(), javaMethodName);
        FunctionObject fo = new FunctionObject(null, javaFunction, scriptable);
        scriptable.defineProperty(jsMethodName, fo, 1);
    }

    static void addProperty(SimpleScriptable scriptable, String propertyName, boolean isGetter, boolean isSetter) {
        String getterName = null;
        if (isGetter) {
            getterName = "jsxGet_" + propertyName;
        }
        String setterName = null;
        if (isSetter) {
            setterName = "jsxSet_" + propertyName;
        }
        ActiveXObject.addProperty(scriptable, propertyName, getterName, setterName);
    }

    static void addProperty(SimpleScriptable scriptable, String propertyName, String getterName, String setterName) {
        scriptable.defineProperty(propertyName, null, ActiveXObject.getMethod(scriptable.getClass(), getterName), ActiveXObject.getMethod(scriptable.getClass(), setterName), 4);
    }

    static Method getMethod(Class<? extends SimpleScriptable> clazz, String name) {
        if (name == null) {
            return null;
        }
        for (Method method : clazz.getMethods()) {
            if (!method.getName().equals(name)) continue;
            return method;
        }
        return null;
    }

    @Override
    public String getClassName() {
        return "ActiveXObject";
    }
}

