/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host;

import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.HtmlApplet;
import com.gargoylesoftware.htmlunit.javascript.host.HTMLElement;
import java.applet.Applet;
import java.lang.reflect.Method;
import net.sourceforge.htmlunit.corejs.javascript.BaseFunction;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.ScriptableObject;

public class HTMLAppletElement
extends HTMLElement {
    private static final long serialVersionUID = 1869359649341296910L;

    public void setDomNode(DomNode domNode) {
        super.setDomNode(domNode);
        if (domNode.getPage().getWebClient().isAppletEnabled()) {
            try {
                this.createAppletMethodAndProperties();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void createAppletMethodAndProperties() throws Exception {
        HtmlApplet appletNode = (HtmlApplet)this.getDomNodeOrDie();
        final Applet applet = appletNode.getApplet();
        if (applet == null) {
            return;
        }
        for (final Method method : applet.getClass().getMethods()) {
            BaseFunction f = new BaseFunction(){
                private static final long serialVersionUID = 1748611972272176674L;

                public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
                    Object[] realArgs = new Object[method.getParameterTypes().length];
                    for (int i = 0; i < realArgs.length; ++i) {
                        Object arg = i > args.length ? null : Context.jsToJava(args[i], method.getParameterTypes()[i]);
                        realArgs[i] = arg;
                    }
                    try {
                        return method.invoke((Object)applet, realArgs);
                    }
                    catch (Exception e) {
                        throw Context.throwAsScriptRuntimeEx(e);
                    }
                }
            };
            ScriptableObject.defineProperty(this, method.getName(), f, 1);
        }
    }

    public String jsxGet_alt() {
        String alt = this.getDomNodeOrDie().getAttribute("alt");
        if (alt == NOT_FOUND) {
            alt = "";
        }
        return alt;
    }

    public void jsxSet_alt(String alt) {
        this.getDomNodeOrDie().setAttribute("alt", alt);
    }

    public String jsxGet_border() {
        String border = this.getDomNodeOrDie().getAttribute("border");
        if (border == NOT_FOUND) {
            border = "";
        }
        return border;
    }

    public void jsxSet_border(String border) {
        this.getDomNodeOrDie().setAttribute("border", border);
    }

    public String jsxGet_align() {
        return this.getAlign();
    }

    public void jsxSet_align(String align) {
        this.setAlign(align, false);
    }
}

