/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host;

import com.gargoylesoftware.htmlunit.Cache;
import com.gargoylesoftware.htmlunit.FailingHttpStatusCodeException;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlLink;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.host.HTMLCollection;
import com.gargoylesoftware.htmlunit.javascript.host.HTMLDocument;
import com.gargoylesoftware.htmlunit.javascript.host.HTMLElement;
import com.gargoylesoftware.htmlunit.javascript.host.HTMLStyleElement;
import com.gargoylesoftware.htmlunit.javascript.host.Stylesheet;
import java.io.IOException;
import java.io.StringReader;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import org.w3c.css.sac.InputSource;
import org.w3c.dom.css.CSSStyleSheet;

public class StyleSheetList
extends SimpleScriptable {
    private static final long serialVersionUID = -8607630805490604483L;
    private HTMLCollection nodes_;

    public StyleSheetList() {
    }

    public StyleSheetList(HTMLDocument document) {
        this.setParentScope(document);
        this.setPrototype(this.getPrototype(this.getClass()));
        this.nodes_ = new HTMLCollection(document);
        boolean cssEnabled = this.getWindow().getWebWindow().getWebClient().isCssEnabled();
        if (cssEnabled) {
            this.nodes_.init(document.getHtmlPage(), ".//style | .//link[lower-case(@rel)='stylesheet']");
        }
    }

    public int jsxGet_length() {
        return this.nodes_.jsxGet_length();
    }

    public Object jsxFunction_item(int index) {
        Stylesheet sheet;
        Cache cache = this.getWindow().getWebWindow().getWebClient().getCache();
        if (index < 0) {
            throw Context.reportRuntimeError("Invalid negative index: " + index);
        }
        if (index >= this.nodes_.jsxGet_length()) {
            return Context.getUndefinedValue();
        }
        HTMLElement element = (HTMLElement)this.nodes_.jsxFunction_item(new Integer(index));
        HtmlElement node = element.getDomNodeOrDie();
        if (element instanceof HTMLStyleElement) {
            sheet = ((HTMLStyleElement)element).jsxGet_sheet();
        } else {
            HtmlLink link = (HtmlLink)node;
            try {
                WebResponse response = link.getWebResponse(true);
                WebClient client = this.getWindow().getWebWindow().getWebClient();
                client.printContentIfNecessary(response);
                client.throwFailingHttpStatusCodeExceptionIfNecessary(response);
                String css = response.getContentAsString();
                CSSStyleSheet cached = cache.getCachedStyleSheet(css);
                if (cached != null) {
                    sheet = new Stylesheet(element, cached);
                } else {
                    String uri = response.getRequestUrl().toExternalForm();
                    InputSource source = new InputSource(new StringReader(css));
                    source.setURI(uri);
                    sheet = new Stylesheet(element, source);
                    cache.cache(css, sheet.getWrappedSheet());
                }
            }
            catch (FailingHttpStatusCodeException e) {
                this.getLog().error(e.getMessage());
                InputSource source = new InputSource(new StringReader(""));
                sheet = new Stylesheet(element, source);
            }
            catch (IOException e) {
                this.getLog().error(e.getMessage());
                InputSource source = new InputSource(new StringReader(""));
                sheet = new Stylesheet(element, source);
            }
            catch (Exception e) {
                throw Context.reportRuntimeError("Exception: " + e);
            }
        }
        return sheet;
    }

    public Object get(int index, Scriptable start) {
        if (this == start) {
            return this.jsxFunction_item(index);
        }
        return super.get(index, start);
    }
}

