/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.util;

import com.gargoylesoftware.htmlunit.WebConnection;
import com.gargoylesoftware.htmlunit.WebRequestSettings;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.util.WebConnectionWrapper;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DebuggingWebConnection
extends WebConnectionWrapper {
    private static final Log LOG = LogFactory.getLog(DebuggingWebConnection.class);
    private int counter_;
    private final WebConnection wrappedWebConnection_;
    private final File javaScriptFile_;
    private final File reportFolder_;

    public DebuggingWebConnection(WebConnection webConnection, String dirName) throws IOException {
        super(webConnection);
        this.wrappedWebConnection_ = webConnection;
        File tmpDir = new File(System.getProperty("java.io.tmpdir"));
        this.reportFolder_ = new File(tmpDir, dirName);
        if (this.reportFolder_.exists()) {
            FileUtils.forceDelete(this.reportFolder_);
        }
        FileUtils.forceMkdir(this.reportFolder_);
        this.javaScriptFile_ = new File(this.reportFolder_, "hu.js");
        this.createOverview();
    }

    @Override
    public WebResponse getResponse(WebRequestSettings settings) throws IOException {
        WebResponse response = this.wrappedWebConnection_.getResponse(settings);
        this.saveResponse(response, settings);
        return response;
    }

    protected void saveResponse(WebResponse response, WebRequestSettings settings) throws IOException {
        ++this.counter_;
        String extension = "application/x-javascript".equals(response.getContentType()) ? ".js" : ("text/html".equals(response.getContentType()) ? ".html" : ".txt");
        File f = this.createFile(settings.getUrl(), extension);
        String content = response.getContentAsString();
        URL url = response.getRequestUrl();
        FileUtils.writeStringToFile(f, content, response.getContentCharSet());
        LOG.info("Created file " + f.getAbsolutePath() + " for response " + this.counter_ + ": " + url);
        StringBuilder buffer = new StringBuilder();
        buffer.append("tab[tab.length] = {code: " + response.getStatusCode() + ", ");
        buffer.append("fileName: '" + f.getName() + "', ");
        buffer.append("contentType: '" + response.getContentType() + "', ");
        buffer.append("method: '" + settings.getHttpMethod().name() + "', ");
        buffer.append("url: '" + url + "', ");
        buffer.append("responseSize: " + response.getContentAsBytes().length + ", ");
        buffer.append("headers: " + DebuggingWebConnection.nameValueListToJsMap(response.getResponseHeaders()));
        buffer.append("};\n");
        FileWriter jsFileWriter = new FileWriter(this.javaScriptFile_, true);
        jsFileWriter.write(buffer.toString());
        jsFileWriter.close();
    }

    private File createFile(URL url, String extension) throws IOException {
        String name = url.getPath().replaceFirst("/$", "").replaceAll(".*/", "");
        name = StringUtils.substringBefore(name, "?");
        if (!(name = StringUtils.substringBefore(name, ";")).endsWith(extension)) {
            name = name + extension;
        }
        int counter = 0;
        String fileName;
        File f;
        while (!(f = new File(this.reportFolder_, fileName = counter != 0 ? StringUtils.substringBeforeLast(name, ".") + "_" + counter + "." + StringUtils.substringAfterLast(name, ".") : name)).createNewFile()) {
            ++counter;
        }
        return f;
    }

    static String nameValueListToJsMap(List<NameValuePair> headers) {
        if (headers == null || headers.isEmpty()) {
            return "{}";
        }
        StringBuilder buffer = new StringBuilder("{");
        for (NameValuePair header : headers) {
            buffer.append("'" + header.getName() + "': '" + header.getValue().replaceAll("'", "\\'") + "', ");
        }
        buffer.delete(buffer.length() - 2, buffer.length());
        buffer.append("}");
        return buffer.toString();
    }

    private void createOverview() throws IOException {
        FileUtils.writeStringToFile(this.javaScriptFile_, "var tab = [];\n", "ISO-8859-1");
        File summary = new File(this.reportFolder_, "index.html");
        String content = "<html><head><title>Summary for " + this.reportFolder_.getName() + "</title>\n" + "<h1>Received responses</h1>\n" + "<script src='" + this.javaScriptFile_.getName() + "' type='text/javascript'></script>\n" + "<script>\n" + "function toKB(bytes)\n" + "{\n" + "  return Math.round(100 * bytes / 1024) / 100;\n" + "}\n" + "function doWork()\n" + "{\n" + "  var totalDownloaded = 0;\n" + "  var list = document.getElementById('list');\n" + "  for (var i=0; i<tab.length; i++) \n" + "  {\n" + "    var curRes = tab[i];\n" + "    list.innerHTML += '<li>' + curRes.code + ' ' + curRes.method + ' ' " + "     + '<a href=\"' + curRes.fileName + '\" target=_blank>' + curRes.url + '</a> " + " (' + curRes.contentType + ') ' + toKB(curRes.responseSize) + ' KB </li>';\n" + "    totalDownloaded += curRes.responseSize;\n" + "  }\n" + "  document.getElementById('totalDownload').innerHTML = toKB(totalDownloaded);\n" + "}\n" + "</script>\n" + "</head>\n" + "<body onload='doWork()'>" + "<ol id='list'>\n" + "</ol>" + "Total download: <span id='totalDownload'>0</span> KB" + "</body></html>";
        FileUtils.writeStringToFile(summary, content, "ISO-8859-1");
        LOG.info("Summary will be in " + summary.getAbsolutePath());
    }
}

