/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cactus.integration.ant.container;

import java.io.File;
import java.io.IOException;
import org.apache.cactus.integration.ant.container.Container;
import org.apache.cactus.integration.ant.deployment.DeployableFile;
import org.apache.cactus.integration.ant.util.AntLog;
import org.apache.cactus.integration.ant.util.AntTaskFactory;
import org.apache.commons.logging.Log;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.filters.ReplaceTokens;
import org.apache.tools.ant.taskdefs.Delete;
import org.apache.tools.ant.types.Environment;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.FilterChain;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.PatternSet;
import org.apache.tools.ant.types.selectors.SelectorUtils;

public abstract class AbstractContainer
extends ProjectComponent
implements Container {
    protected static final String RESOURCE_PATH = "/org/apache/cactus/integration/ant/container/resources/";
    private DeployableFile deployableFile;
    private PatternSet patternSet = new PatternSet();
    private File toDir;
    private String ifCondition;
    private String unlessCondition;
    private AntTaskFactory antTaskFactory;
    private Log log = AntLog.NULL;
    private Environment.Variable[] systemProperties;
    private long startUpWait = 1000L;
    private Path containerClasspath;
    private String server = "localhost";
    private String protocol = "http";

    public String getTestContext() {
        return null;
    }

    public void setStartUpWait(long theStartUpWait) {
        this.startUpWait = theStartUpWait;
    }

    public final PatternSet.NameEntry createExclude() {
        return this.patternSet.createExclude();
    }

    public final String[] getExcludePatterns() {
        return this.patternSet.getExcludePatterns(this.getProject());
    }

    public final void setIf(String theIfCondition) {
        this.ifCondition = theIfCondition;
    }

    public final void setToDir(File theToDir) {
        this.toDir = theToDir;
    }

    public final void setUnless(String theUnlessCondition) {
        this.unlessCondition = theUnlessCondition;
    }

    public final void setServer(String theServer) {
        this.server = theServer;
    }

    public final void setProtocol(String theProtocol) {
        this.protocol = theProtocol;
    }

    public long getStartUpWait() {
        return this.startUpWait;
    }

    public final File getToDir() {
        return this.toDir;
    }

    public void init() {
    }

    public final boolean isEnabled() {
        return this.testIfCondition() && this.testUnlessCondition();
    }

    public final boolean isExcluded(String theTestName) {
        String[] excludePatterns = this.patternSet.getExcludePatterns(this.getProject());
        if (excludePatterns != null) {
            String testPath = theTestName.replace('.', '/');
            for (int i = 0; i < excludePatterns.length; ++i) {
                String excludePattern = excludePatterns[i];
                if (excludePattern.endsWith(".java") || excludePattern.endsWith(".class")) {
                    excludePattern = excludePattern.substring(0, excludePattern.lastIndexOf(46));
                }
                if (!SelectorUtils.matchPath((String)excludePattern, (String)testPath)) continue;
                return true;
            }
        }
        return false;
    }

    public final void setAntTaskFactory(AntTaskFactory theFactory) {
        this.antTaskFactory = theFactory;
    }

    public final void setDeployableFile(DeployableFile theDeployableFile) {
        this.deployableFile = theDeployableFile;
    }

    public final void setLog(Log theLog) {
        this.log = theLog;
    }

    public void setSystemProperties(Environment.Variable[] theProperties) {
        this.systemProperties = theProperties;
    }

    public Environment.Variable[] getSystemProperties() {
        return this.systemProperties;
    }

    public void setContainerClasspath(Path theClasspath) {
        this.containerClasspath = theClasspath;
    }

    public Path getContainerClasspath() {
        return this.containerClasspath;
    }

    public final String getServer() {
        return this.server;
    }

    public final String getProtocol() {
        return this.protocol;
    }

    public final String getBaseURL() {
        return this.getProtocol() + "://" + this.getServer() + ":" + this.getPort();
    }

    protected final Task createAntTask(String theName) {
        return this.antTaskFactory.createTask(theName);
    }

    protected final File createDirectory(File theParentDir, String theName) throws IOException {
        File dir = new File(theParentDir, theName);
        dir.mkdirs();
        if (!dir.isDirectory()) {
            throw new IOException("Couldn't create directory " + dir.getAbsolutePath());
        }
        return dir;
    }

    protected final FilterChain createFilterChain() {
        ReplaceTokens.Token token = null;
        FilterChain filterChain = new FilterChain();
        ReplaceTokens replacePort = new ReplaceTokens();
        token = new ReplaceTokens.Token();
        token.setKey("cactus.port");
        token.setValue(String.valueOf(this.getPort()));
        replacePort.addConfiguredToken(token);
        filterChain.addReplaceTokens(replacePort);
        if (this.getDeployableFile() != null) {
            ReplaceTokens replaceContext = new ReplaceTokens();
            token = new ReplaceTokens.Token();
            token.setKey("cactus.context");
            token.setValue(this.getDeployableFile().getTestContext());
            replaceContext.addConfiguredToken(token);
            filterChain.addReplaceTokens(replaceContext);
        }
        return filterChain;
    }

    protected void cleanTempDirectory(File theTmpDir) {
        Delete delete = (Delete)this.createAntTask("delete");
        FileSet fileSet = new FileSet();
        fileSet.setDir(theTmpDir);
        fileSet.createInclude().setName("**/*");
        delete.addFileset(fileSet);
        delete.setIncludeEmptyDirs(true);
        delete.setFailOnError(false);
        delete.execute();
    }

    protected File setupTempDirectory(File theCustomTmpDir, String theName) {
        File tmpDir = theCustomTmpDir == null ? new File(System.getProperty("java.io.tmpdir"), theName) : theCustomTmpDir;
        if (!tmpDir.exists() && !tmpDir.mkdirs()) {
            throw new BuildException("Could not create temporary directory [" + tmpDir + "]");
        }
        if (!tmpDir.isDirectory()) {
            throw new BuildException("[" + tmpDir + "] is not a directory");
        }
        return tmpDir;
    }

    protected final Log getLog() {
        return this.log;
    }

    protected final DeployableFile getDeployableFile() {
        return this.deployableFile;
    }

    private boolean testIfCondition() {
        if (this.ifCondition == null || this.ifCondition.length() == 0) {
            return true;
        }
        return this.getProject().getProperty(this.ifCondition) != null;
    }

    private boolean testUnlessCondition() {
        if (this.unlessCondition == null || this.unlessCondition.length() == 0) {
            return true;
        }
        return this.getProject().getProperty(this.unlessCondition) == null;
    }
}

