/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cactus.integration.ant.container;

import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import org.apache.cactus.integration.ant.container.Container;
import org.apache.tools.ant.BuildException;

public class ContainerFactory {
    private static final String DEFAULT_CONTAINERS_BUNDLE = "org.apache.cactus.integration.ant.container.default";
    private ResourceBundle defaultContainers = PropertyResourceBundle.getBundle("org.apache.cactus.integration.ant.container.default");

    public final Container createContainer(String theName) throws BuildException {
        Container container = null;
        try {
            String className = this.defaultContainers.getString(theName);
            if (className == null) {
                throw this.unsupportedContainer(theName, null);
            }
            Class<?> clazz = Class.forName(className);
            container = (Container)clazz.newInstance();
        }
        catch (MissingResourceException mre) {
            throw this.unsupportedContainer(theName, mre);
        }
        catch (ClassCastException cce) {
            throw this.unsupportedContainer(theName, cce);
        }
        catch (ClassNotFoundException cnfe) {
            throw this.unsupportedContainer(theName, cnfe);
        }
        catch (InstantiationException ie) {
            throw this.unsupportedContainer(theName, ie);
        }
        catch (IllegalAccessException iae) {
            throw this.unsupportedContainer(theName, iae);
        }
        return container;
    }

    private BuildException unsupportedContainer(String theName, Exception theCause) {
        if (theCause != null) {
            return new BuildException("The container '" + theName + "' is not supported", (Throwable)theCause);
        }
        return new BuildException("The container '" + theName + "' is not supported");
    }
}

