/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cactus.internal.configuration;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import org.apache.cactus.internal.util.ClassLoaderUtils;
import org.apache.cactus.util.ChainedRuntimeException;
import org.apache.cactus.util.log.LogAspect;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.AroundClosure;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

public class ConfigurationInitializer {
    private static final String DEFAULT_CONFIG_NAME = "cactus";
    private static final String CACTUS_CONFIG_PROPERTY = "cactus.config";
    private static final String CACTUS_LOGGING_CONFIG_PROPERTY = "cactus.logging.config";
    private static boolean isInitialized;
    static /* synthetic */ Class class$0;
    private static final JoinPoint.StaticPart ajc$tjp_0;

    public static synchronized void initialize(boolean bl) {
        boolean bl2 = bl;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_0, null, null, Conversions.booleanObject(bl2));
        ConfigurationInitializer.initialize_aroundBody1$advice(bl2, joinPoint, LogAspect.aspectOf(), null, joinPoint);
    }

    public static synchronized void initialize() {
        ConfigurationInitializer.initialize(false);
    }

    private static void initializeConfig(boolean isReinitialization) {
        ResourceBundle config;
        String configOverride = System.getProperty(CACTUS_CONFIG_PROPERTY);
        if (configOverride == null) {
            try {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.apache.cactus.internal.configuration.ConfigurationInitializer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                config = ClassLoaderUtils.loadPropertyResourceBundle(DEFAULT_CONFIG_NAME, clazz);
            }
            catch (MissingResourceException missingResourceException) {
                return;
            }
        }
        try {
            config = new PropertyResourceBundle(new FileInputStream(configOverride));
        }
        catch (IOException e) {
            throw new ChainedRuntimeException("Cannot read cactus configuration file [" + configOverride + "]", e);
        }
        ConfigurationInitializer.addSystemProperties(config, isReinitialization);
    }

    private static void initializeLoggingConfig(boolean isReinitialization) {
        String logConfig = System.getProperty(CACTUS_LOGGING_CONFIG_PROPERTY);
        if (logConfig != null) {
            PropertyResourceBundle bundle;
            try {
                bundle = new PropertyResourceBundle(new FileInputStream(logConfig));
            }
            catch (IOException iOException) {
                throw new ChainedRuntimeException("Failed to load logging configuration file [" + logConfig + "]");
            }
            ConfigurationInitializer.addSystemProperties(bundle, isReinitialization);
        }
    }

    private static void addSystemProperties(ResourceBundle theBundle, boolean isReinitialization) {
        Enumeration<String> keys = theBundle.getKeys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            if (System.getProperty(key) != null && !isReinitialization) continue;
            System.setProperty(key, theBundle.getString(key));
        }
    }

    static {
        Factory factory = new Factory("ConfigurationInitializer.java", Class.forName("org.apache.cactus.internal.configuration.ConfigurationInitializer"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("29-initialize-org.apache.cactus.internal.configuration.ConfigurationInitializer-boolean:-isReinitialization:--void-"), 72);
    }

    private static final void initialize_aroundBody0(boolean bl, JoinPoint joinPoint) {
        if (!isInitialized) {
            ConfigurationInitializer.initializeConfig(bl);
            ConfigurationInitializer.initializeLoggingConfig(bl);
            isInitialized = true;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final Object initialize_aroundBody1$advice(boolean this_, JoinPoint ajc_aroundClosure, LogAspect thisJoinPoint, AroundClosure aroundClosure, JoinPoint joinPoint) {
        void logger;
        Log log = LogFactory.getLog(joinPoint.getSignature().getDeclaringType());
        if (log.isDebugEnabled()) {
            void result;
            log.debug(String.valueOf('<') + LogAspect.ajc$inlineAccessMethod$org_apache_cactus_util_log_LogAspect$org_apache_cactus_util_log_LogAspect$getFullSignature(thisJoinPoint, joinPoint));
            void var7_6 = logger;
            ConfigurationInitializer.initialize_aroundBody0(this_, ajc_aroundClosure);
            Object var6_7 = null;
            log.debug(String.valueOf('>') + result.getSignature().getName());
            return var6_7;
        }
        void var8_8 = logger;
        ConfigurationInitializer.initialize_aroundBody0(this_, ajc_aroundClosure);
        return null;
    }
}

