/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.weblogic;

import java.io.File;
import java.util.Iterator;
import org.apache.tools.ant.types.FilterChain;
import org.apache.tools.ant.util.FileUtils;
import org.codehaus.cargo.container.Container;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.configuration.ConfigurationCapability;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.WAR;
import org.codehaus.cargo.container.internal.weblogic.WebLogicStandaloneConfigurationCapability;
import org.codehaus.cargo.container.spi.AbstractStandaloneConfiguration;

public class WebLogicStandaloneConfiguration
extends AbstractStandaloneConfiguration {
    private ConfigurationCapability capability = new WebLogicStandaloneConfigurationCapability();

    public WebLogicStandaloneConfiguration(Container container) {
        super(container);
    }

    public WebLogicStandaloneConfiguration(Container container, File configDir) {
        super(container, configDir);
    }

    public ConfigurationCapability getCapability() {
        return this.capability;
    }

    public void configure() {
        try {
            this.createConfigurationDir();
            FilterChain filterChain = this.createWebLogicFilterChain();
            File testDomainDir = this.getFileUtils().createDirectory(this.getDir(), "domain");
            this.getResourceUtils().copyResource("/org/codehaus/cargo/container/internal/resources/" + this.getContainer().getId() + "/config.xml", new File(testDomainDir, "config.xml"), filterChain);
            this.getResourceUtils().copyResource("/org/codehaus/cargo/container/internal/resources/" + this.getContainer().getId() + "/DefaultAuthenticatorInit.ldift", new File(testDomainDir, "DefaultAuthenticatorInit.ldift"), filterChain);
            this.setupDeployables(testDomainDir);
        }
        catch (Exception e) {
            throw new ContainerException("Failed to create a " + this.getContainer().getName() + " container configuration", e);
        }
    }

    private FilterChain createWebLogicFilterChain() {
        FilterChain filterChain = this.createFilterChain();
        StringBuffer appTokenValue = new StringBuffer(" ");
        Iterator it = this.getDeployables().iterator();
        while (it.hasNext()) {
            Deployable deployable = (Deployable)it.next();
            if (!(deployable instanceof WAR) || !((WAR)deployable).isExpandedWar()) continue;
            String context = ((WAR)deployable).getContext();
            appTokenValue.append("<Application ");
            appTokenValue.append("Name=\"_" + context + "_app\" ");
            appTokenValue.append("Path=\"" + deployable.getFile().getParent() + "\" ");
            appTokenValue.append("StagedTargets=\"server\" StagingMode=\"stage\" TwoPhase=\"true\"");
            appTokenValue.append(">");
            appTokenValue.append("<WebAppComponent ");
            appTokenValue.append("Name=\"" + context + "\" ");
            appTokenValue.append("Targets=\"server\" ");
            appTokenValue.append("URI=\"" + context + "\"");
            appTokenValue.append("/></Application>");
        }
        this.getAntUtils().addTokenToFilterChain(filterChain, "weblogic.apps", appTokenValue.toString());
        return filterChain;
    }

    protected void setupDeployables(File domainDir) {
        try {
            FileUtils fileUtils = FileUtils.newFileUtils();
            File appDir = this.getFileUtils().createDirectory(domainDir, "applications");
            Iterator it = this.getDeployables().iterator();
            while (it.hasNext()) {
                Deployable deployable = (Deployable)it.next();
                if (deployable instanceof WAR && ((WAR)deployable).isExpandedWar()) continue;
                fileUtils.copyFile(deployable.getFile(), new File(appDir, deployable.getFile().getName()), null, true);
            }
            this.getResourceUtils().copyResource("/org/codehaus/cargo/container/internal/resources/cargocpc.war", new File(appDir, "cargocpc.war"));
        }
        catch (Exception e) {
            throw new ContainerException("Failed to deploy Deployables in the " + this.getContainer().getName() + " [" + domainDir + "] domain directory", e);
        }
    }
}

