/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jsfunit.framework;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.TopLevelWindow;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebWindow;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import org.jboss.jsfunit.framework.FaceletsErrorPageDetector;
import org.jboss.jsfunit.framework.InitialRequestStrategy;
import org.jboss.jsfunit.framework.JSFUnitFilter;
import org.jboss.jsfunit.framework.JSFUnitWebConnection;
import org.jboss.jsfunit.framework.SimpleInitialRequestStrategy;
import org.jboss.jsfunit.framework.WebConversationFactory;
import org.jboss.jsfunit.seam.SeamRequestListener;
import org.jboss.jsfunit.seam.SeamUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebClientSpec
implements HttpSessionBindingListener {
    public static final String SESSION_KEY = WebClientSpec.class.getName() + "sessionkey";
    private static BrowserVersion DEFAULT_BROWSER_VERSION = BrowserVersion.getDefault();
    private String initialPage;
    private WebClient webClient;
    private BrowserVersion browserVersion;
    private String proxyHost;
    private int proxyPort;
    private Map<String, String> cookies = new HashMap<String, String>();
    private InitialRequestStrategy requestStrategy = new SimpleInitialRequestStrategy();
    private boolean initialRequestDone = false;

    public WebClientSpec(String initialPage) {
        this(initialPage, DEFAULT_BROWSER_VERSION);
    }

    public WebClientSpec(String initialPage, BrowserVersion browserVersion) {
        this(initialPage, browserVersion, null, 0);
    }

    public WebClientSpec(String initialPage, BrowserVersion browserVersion, String proxyHost, int proxyPort) {
        this.initialPage = initialPage;
        this.browserVersion = browserVersion;
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
        WebConversationFactory.makeWebClient(this);
        this.setFaceletsErrorDetector();
    }

    private void setFaceletsErrorDetector() {
        JSFUnitWebConnection webConnection = (JSFUnitWebConnection)this.webClient.getWebConnection();
        webConnection.addListener(new FaceletsErrorPageDetector());
    }

    public static Map getRedirectorRequestParams() {
        return (Map)WebConversationFactory.getSessionFromThreadLocal().getAttribute(JSFUnitFilter.REDIRECTOR_REQUEST_PARAMS_KEY);
    }

    public String getInitialPage() {
        return this.initialPage;
    }

    void setWebClient(WebClient webClient) {
        this.webClient = webClient;
    }

    public WebClient getWebClient() {
        return this.webClient;
    }

    public BrowserVersion getBrowserVersion() {
        return this.browserVersion;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public void setInitialRequestStrategy(InitialRequestStrategy requestStrategy) {
        this.requestStrategy = requestStrategy;
    }

    public void addCookie(String name, String value) {
        this.cookies.put(name, value);
        this.addCookiesToHeader();
    }

    public String removeCookie(String name) {
        String value = this.cookies.remove(name);
        this.addCookiesToHeader();
        return value;
    }

    public Map<String, String> getCookies() {
        return Collections.unmodifiableMap(this.cookies);
    }

    public Page doInitialRequest() throws IOException {
        if (this.initialRequestDone) {
            throw new IllegalStateException("Initial request was already made.");
        }
        this.addCookiesToHeader();
        this.doSeamSetup();
        Page page = this.requestStrategy.doInitialRequest(this);
        this.initialRequestDone = true;
        return page;
    }

    private void doSeamSetup() {
        if (!SeamUtil.isSeamPresent()) {
            return;
        }
        SeamUtil.suppressSeamComponentWarning();
        JSFUnitWebConnection webConnection = (JSFUnitWebConnection)this.webClient.getWebConnection();
        webConnection.addListener(new SeamRequestListener());
    }

    protected void addCookiesToHeader() {
        StringBuilder builder = new StringBuilder();
        Map<String, String> cookies = this.getCookies();
        Iterator<String> i = cookies.keySet().iterator();
        while (i.hasNext()) {
            String key = i.next();
            String value = cookies.get(key);
            builder.append(key).append("=").append(value);
            if (!i.hasNext()) continue;
            builder.append(";");
        }
        this.getWebClient().addRequestHeader("Cookie", builder.toString());
    }

    public void valueUnbound(HttpSessionBindingEvent httpSessionBindingEvent) {
        ArrayList<TopLevelWindow> topWindows = new ArrayList<TopLevelWindow>();
        for (WebWindow webWindow : this.webClient.getWebWindows()) {
            if (!(webWindow instanceof TopLevelWindow)) continue;
            topWindows.add((TopLevelWindow)webWindow);
        }
        for (TopLevelWindow topLevelWindow : topWindows) {
            topLevelWindow.close();
        }
    }

    public void valueBound(HttpSessionBindingEvent httpSessionBindingEvent) {
    }
}

